/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.collections.message.FinalHashMap;
import com.atlassian.bamboo.collections.message.FinalLinkedList;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.BambooInterners;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowableDetails
implements Serializable {
    private static final String REPOSITORY = "ThrowableDetails.repositoryId";
    private final String name;
    private final String message;
    private final String stackTrace;
    private final FinalLinkedList<String> causeStack;
    private final FinalHashMap<String, String> metadata = new FinalHashMap();

    private ThrowableDetails(@NotNull Throwable throwable, @Nullable Map<String, String> metadata) {
        this.name = BambooInterners.intern(throwable.getClass().getName());
        this.message = BambooInterners.intern(throwable.getMessage());
        this.stackTrace = BambooInterners.intern(ExceptionUtils.getStackTrace((Throwable)throwable));
        this.causeStack = this.generateCauseStack(throwable);
        if (metadata != null) {
            this.metadata.putAll(metadata);
        }
    }

    private FinalLinkedList<String> generateCauseStack(@Nullable Throwable throwable) {
        FinalLinkedList<String> stack = new FinalLinkedList<String>();
        while (throwable != null) {
            Long repositoryId;
            stack.add(BambooInterners.intern(throwable.getClass().getName()));
            if (this.getRepositoryId() == null && throwable instanceof RepositoryException && (repositoryId = ((RepositoryException)throwable).getRepositoryId()) != null) {
                this.metadata.put(REPOSITORY, repositoryId.toString());
            }
            if (throwable == throwable.getCause()) break;
            throwable = throwable.getCause();
        }
        return stack;
    }

    @Nullable
    public static ThrowableDetails fromThrowable(@Nullable Throwable throwable) {
        return ThrowableDetails.fromThrowable(throwable, null);
    }

    @Nullable
    public static ThrowableDetails fromThrowable(@Nullable Throwable throwable, @Nullable Map<String, String> metadata) {
        return throwable == null ? null : new ThrowableDetails(throwable, metadata);
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public Long getRepositoryId() {
        String repositoryId = (String)this.metadata.get(REPOSITORY);
        if (repositoryId != null) {
            return Long.parseLong(repositoryId);
        }
        return null;
    }

    @NotNull
    public ImmutableList<String> getCauseStack() {
        return ImmutableList.copyOf(this.causeStack);
    }

    @NotNull
    public Map<String, String> getMetadata() {
        return ImmutableMap.copyOf(this.metadata);
    }
}

