/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.core.BambooEntityOid;
import com.atlassian.bamboo.core.BambooEntityType;
import com.atlassian.bamboo.persistence3.BambooObjectWithOidDao;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.ChainBranch;
import com.atlassian.bamboo.plan.branch.ChainBranchIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.Project;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.user.User;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface PlanDao
extends BambooObjectWithOidDao<Plan> {
    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull PlanKey var1, Class<T> var2);

    @Nullable
    public <T extends Plan> T getPlanByKey(@NotNull String var1, Class<T> var2);

    @Nullable
    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(@NotNull String var1);

    @Nullable
    public Class<? extends Plan> getPlanClass(@NotNull PlanKey var1);

    public boolean isChainNameConflicting(@NotNull String var1, long var2, @NotNull String var4);

    public boolean isPlanKeyConflicting(@NotNull PlanKey var1);

    public boolean isPlanKeyConflicting(@NotNull PlanKey var1, long var2);

    @Nullable
    public <T extends Plan> T getPlanByPartialKeyAndName(@NotNull PlanKey var1, @NotNull String var2, Class<T> var3);

    public <T extends Plan> int getPlanCount(Class<T> var1);

    public <T extends Plan> List<T> findPlansByProject(@NotNull Project var1, Class<T> var2);

    public <T extends Plan> List<T> findAllPlansByProject(@NotNull Project var1, Class<T> var2);

    @NotNull
    public <T extends Plan> List<T> findAllPlans(Class<T> var1);

    @NotNull
    public <T extends Plan> List<T> findAllPlans(Class<T> var1, int var2, int var3);

    public List<ImmutableChain> filterFavouritedPlans(@NotNull Collection<? extends ImmutableChain> var1, @NotNull User var2);

    @NotNull
    public <T extends Plan> Collection<T> getAllPlansMarkedForDeletion(Class<T> var1);

    @NotNull
    public <T extends Plan> List<PlanKey> getPlanKeys(Class<T> var1);

    @NotNull
    public List<PlanKey> getJobKeys(@NotNull PlanKey var1);

    @NotNull
    public List<ChainBranch> getBranchesForChain(ImmutableChain var1);

    public Collection<Job> getBranchesForJob(Job var1);

    @NotNull
    public List<ChainBranchIdentifier> getBranchIdentifiersForChain(@NotNull PlanIdentifier var1);

    @NotNull
    public <T extends Plan> List<PlanIdentifier> getPlanIdentifiersForProject(@NotNull ProjectIdentifier var1, @NotNull Class<T> var2, boolean var3);

    public int getBranchCount(@NotNull ImmutablePlan var1);

    public List<Pair<Number, Number>> getBranchesCount();

    public void markPlanForDeletion(PlanKey var1);

    public void syncDeletionStatusOfJobs();

    @Nullable
    public BambooEntityOid getMaxPlanOid(int var1, @NotNull BambooEntityType var2);
}

