/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.chains.branches;

import com.atlassian.bamboo.specs.api.model.plan.branches.PlanBranchManagementProperties;
import java.util.Arrays;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public enum BranchNotificationStrategy {
    NOTIFY_COMMITTERS("notifyCommitters"),
    INHERIT("inherit"),
    NONE("none");

    private static final Map<String, BranchNotificationStrategy> KEYS_TO_BNS;
    private final String key;

    private BranchNotificationStrategy(String key) {
        this.key = key;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public static BranchNotificationStrategy fromKey(@NotNull String key) {
        if (KEYS_TO_BNS.containsKey(key)) {
            return KEYS_TO_BNS.get(key);
        }
        throw new IllegalArgumentException(key + " is not BranchNotificationStrategy");
    }

    @NotNull
    public PlanBranchManagementProperties.NotificationStrategy toSpecsConstant() {
        return PlanBranchManagementProperties.NotificationStrategy.valueOf((String)this.name());
    }

    @NotNull
    public static BranchNotificationStrategy fromSpecsConstant(@NotNull PlanBranchManagementProperties.NotificationStrategy exportConstant) {
        return BranchNotificationStrategy.valueOf(exportConstant.name());
    }

    static {
        KEYS_TO_BNS = Arrays.stream(BranchNotificationStrategy.values()).collect(Collectors.toMap(BranchNotificationStrategy::getKey, UnaryOperator.identity()));
    }
}

