/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;

public class AutomaticInstanceManagementConfig
implements Serializable {
    public static final String CUSTOM = "Custom";
    static final int ELASTIC_BUILDS_IN_QUEUE_THRESHOLD = 3;
    static final int TOTAL_BUILDS_IN_QUEUE_THRESHOLD = 5;
    static final Duration AVERAGE_TIME_IN_QUEUE_THRESHOLD = Duration.ofMinutes(5L);
    static final int MAX_NUM_ELASTIC_INSTANCES_TO_START = 2;
    static final Duration ELASTIC_AGENT_IDLE_THRESHOLD = Duration.ofMinutes(10L);
    public static final AutomaticInstanceManagementConfig DEFAULT_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Default", true);
    public static final AutomaticInstanceManagementConfig DISABLED_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Disabled", false);
    public static final AutomaticInstanceManagementConfig CUSTOM_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Custom", true);
    public static final AutomaticInstanceManagementConfig PASSIVE_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Passive", true, AVERAGE_TIME_IN_QUEUE_THRESHOLD.multipliedBy(2L).toMillis(), 6, 10, 1, ELASTIC_AGENT_IDLE_THRESHOLD.toMillis());
    public static final AutomaticInstanceManagementConfig AGGRESSIVE_INSTANCE_MANAGEMENT_CONFIG = new AutomaticInstanceManagementConfig("Aggressive", true, AVERAGE_TIME_IN_QUEUE_THRESHOLD.dividedBy(2L).toMillis(), 1, 2, 4, ELASTIC_AGENT_IDLE_THRESHOLD.toMillis());
    public static final List<AutomaticInstanceManagementConfig> AUTOMATIC_INSTANCE_MANAGEMENT_CONFIG_LIST = ImmutableList.of((Object)DEFAULT_INSTANCE_MANAGEMENT_CONFIG, (Object)AGGRESSIVE_INSTANCE_MANAGEMENT_CONFIG, (Object)PASSIVE_INSTANCE_MANAGEMENT_CONFIG, (Object)CUSTOM_INSTANCE_MANAGEMENT_CONFIG, (Object)DISABLED_INSTANCE_MANAGEMENT_CONFIG);
    private long averageTimeInQueueThreshold = AVERAGE_TIME_IN_QUEUE_THRESHOLD.toMillis();
    private int elasticBuildsInQueueThreshold = 3;
    private int totalBuildInQueueThreshold = 5;
    private int maxElasticInstancesToStartAtOnce = 2;
    private long instanceIdleTimeThreshold = ELASTIC_AGENT_IDLE_THRESHOLD.toMillis();
    private final boolean automaticInstanceManagementEnabled;
    private final String configurationName;
    private int maxNonBambooInstances = 1;

    private AutomaticInstanceManagementConfig(String configName, boolean automaticInstanceManagementEnabled) {
        this.configurationName = configName;
        this.automaticInstanceManagementEnabled = automaticInstanceManagementEnabled;
    }

    private AutomaticInstanceManagementConfig(String configurationName, boolean automaticInstanceManagementEnabled, long averageTimeInQueueThreshold, int elasticBuildsInQueueThreshold, int totalBuildInQueueThreshold, int maxElasticInstancesToStartAtOnce, long instanceIdleTimeThreshold) {
        this(configurationName, automaticInstanceManagementEnabled);
        this.averageTimeInQueueThreshold = averageTimeInQueueThreshold;
        this.elasticBuildsInQueueThreshold = elasticBuildsInQueueThreshold;
        this.totalBuildInQueueThreshold = totalBuildInQueueThreshold;
        this.maxElasticInstancesToStartAtOnce = maxElasticInstancesToStartAtOnce;
        this.instanceIdleTimeThreshold = instanceIdleTimeThreshold;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public boolean isAutomaticInstanceManagementEnabled() {
        return this.automaticInstanceManagementEnabled;
    }

    private void assertChangingAllowed() {
        if (!CUSTOM.equals(this.configurationName)) {
            throw new IllegalStateException("Changing parameters is only allowed for 'Custom' configuration");
        }
    }

    public long getAverageTimeInQueueThreshold() {
        return this.averageTimeInQueueThreshold;
    }

    public void setAverageTimeInQueueThreshold(long averageTimeInQueueThreshold) {
        this.assertChangingAllowed();
        this.averageTimeInQueueThreshold = averageTimeInQueueThreshold;
    }

    public int getElasticBuildsInQueueThreshold() {
        return this.elasticBuildsInQueueThreshold;
    }

    public void setElasticBuildsInQueueThreshold(int elasticBuildsInQueueThreshold) {
        this.assertChangingAllowed();
        this.elasticBuildsInQueueThreshold = elasticBuildsInQueueThreshold;
    }

    public int getTotalBuildInQueueThreshold() {
        return this.totalBuildInQueueThreshold;
    }

    public void setTotalBuildInQueueThreshold(int totalBuildInQueueThreshold) {
        this.assertChangingAllowed();
        this.totalBuildInQueueThreshold = totalBuildInQueueThreshold;
    }

    public int getMaxElasticInstancesToStartAtOnce() {
        return this.maxElasticInstancesToStartAtOnce;
    }

    public void setMaxElasticInstancesToStartAtOnce(int maxElasticInstancesToStartAtOnce) {
        this.assertChangingAllowed();
        this.maxElasticInstancesToStartAtOnce = maxElasticInstancesToStartAtOnce;
    }

    public long getInstanceIdleTimeThreshold() {
        return this.instanceIdleTimeThreshold;
    }

    public void setInstanceIdleTimeThreshold(long instanceIdleTimeThreshold) {
        this.assertChangingAllowed();
        this.instanceIdleTimeThreshold = instanceIdleTimeThreshold;
    }

    public int getMaxNonBambooInstances() {
        return this.maxNonBambooInstances;
    }

    public void setMaxNonBambooInstances(int maxNonBambooInstances) {
        this.maxNonBambooInstances = maxNonBambooInstances;
    }
}

