/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.validation;

import com.atlassian.bamboo.utils.error.ErrorCollection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ValidationService {
    public static final String FULL_JOB_KEY_REGEXP = "[A-Z][A-Z0-9]{1,}(-[A-Z][A-Z0-9]{1,}){2,2}";
    public static final String PARTIAL_JOB_KEY_REGEXP = "[A-Z][A-Z0-9]{1,}";

    @NotNull
    public ErrorCollection validateKey(@NotNull String var1, @NotNull ValidationType var2, @Nullable String var3, ValidationFunction ... var4);

    @NotNull
    public ErrorCollection validateName(@NotNull String var1, @NotNull String var2, @Nullable String var3);

    @NotNull
    public ErrorCollection validateDescription(@NotNull String var1, @Nullable String var2);

    public static interface ValidationFunction {
        public void validate(@NotNull String var1, @NotNull String var2, @NotNull ErrorCollection var3);
    }

    public static enum ValidationType {
        JOB("job", "[A-Z][A-Z0-9]{1,}(-[A-Z][A-Z0-9]{1,}){2,2}");

        private String errorPrefix;
        private Pattern keyPattern;

        private ValidationType(String errorPrefix, String keyRegex) {
            this.errorPrefix = errorPrefix;
            this.keyPattern = Pattern.compile(keyRegex);
        }

        public String getErrorPrefix() {
            return this.errorPrefix;
        }

        public Pattern getKeyPattern() {
            return this.keyPattern;
        }
    }
}

