/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.v2.build.agent.AbstractAgentStatus;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildAwareAgentStatus
extends AbstractAgentStatus {
    private static final Logger log = Logger.getLogger(AbstractBuildAwareAgentStatus.class);
    protected final ResultKey resultKey;
    protected final String displayName;
    protected final long deploymentResultId;

    @Deprecated
    public AbstractBuildAwareAgentStatus(String planKey, String buildResultKey) {
        this.resultKey = PlanKeys.getPlanResultKey(buildResultKey);
        this.displayName = this.resultKey.getKey();
        this.deploymentResultId = -1L;
    }

    public AbstractBuildAwareAgentStatus(ResultKey resultKey, String displayName, long deploymentResultId) {
        this.resultKey = resultKey;
        this.displayName = displayName;
        this.deploymentResultId = deploymentResultId;
    }

    @Override
    @Nullable
    public String getUrl() {
        if (this.deploymentResultId != -1L) {
            return "/deploy/viewDeploymentResult.action?deploymentResultId=" + this.deploymentResultId;
        }
        return "/browse/" + this.resultKey + "/log";
    }

    @Override
    public boolean isAllowDelete() {
        return false;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public ResultKey getResultKey() {
        return this.resultKey;
    }

    @Deprecated
    public String getBuildResultKey() {
        return this.resultKey.getKey();
    }

    @Deprecated
    public String getPlanKey() {
        return this.resultKey.getEntityKey().getKey();
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

