/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.NameProvider;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class NameProviderFunctions {
    private static final Function<NameProvider, String> GET_NAME = new Function<NameProvider, String>(){

        public String apply(NameProvider input) {
            return input.getName();
        }
    };

    private NameProviderFunctions() {
    }

    @NotNull
    public static Function<NameProvider, String> getName() {
        return GET_NAME;
    }

    @NotNull
    public static Predicate<NameProvider> hasEqualName(@NotNull String name) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)name), GET_NAME);
    }

    @NotNull
    public static Predicate<NameProvider> isNameIn(@NotNull Collection<String> names) {
        return Predicates.compose((Predicate)Predicates.in(names), GET_NAME);
    }
}

