/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class JavaVirtualMachineDetector {
    private static final Logger log = Logger.getLogger(JavaVirtualMachineDetector.class);
    private static final String JAVA_VERSION_PATTERN = "java version \\\"(.+)\\\"";
    private static final String VERSION_CMD_OPTION = "-version";
    private boolean myIsRunningOnOsx;

    public JavaVirtualMachineDetector(boolean isRunningOnOsx) {
        this.myIsRunningOnOsx = isRunningOnOsx;
    }

    public String detectJavaHome(String systemJavaHome) {
        if (!this.myIsRunningOnOsx && systemJavaHome != null) {
            File systemJavaHomeDirectory = new File(systemJavaHome);
            if (this.containsJavac(systemJavaHomeDirectory)) {
                return systemJavaHome;
            }
            File parentDirectory = systemJavaHomeDirectory.getParentFile();
            if (this.containsJavac(parentDirectory)) {
                return systemJavaHomeDirectory.getParent();
            }
        }
        return systemJavaHome;
    }

    public boolean containsJavac(File givenDirectory) {
        if (this.myIsRunningOnOsx) {
            return true;
        }
        File javac = new File(givenDirectory, "bin" + File.separator + "javac");
        File javacWindows = new File(givenDirectory, "bin" + File.separator + "javac.exe");
        return javac.exists() || javacWindows.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public String detectExternalJdkVersion(File givenDirectory) {
        if (givenDirectory.equals(SystemUtils.getJavaHome())) return SystemUtils.JAVA_VERSION;
        if (givenDirectory.equals(new File(SystemUtils.getJavaHome().getParent()))) {
            return SystemUtils.JAVA_VERSION;
        }
        if (!this.containsJavac(givenDirectory)) return null;
        try {
            String javaCommand = givenDirectory + File.separator + "bin" + File.separator + "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
            ProcessBuilder pb = new ProcessBuilder(Lists.newArrayList((Object[])new String[]{javaCommand, VERSION_CMD_OPTION}));
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            try {
                String versionLine = br.readLine();
                if (versionLine == null) return null;
                Pattern versionPattern = Pattern.compile(JAVA_VERSION_PATTERN);
                Matcher matcher = versionPattern.matcher(versionLine);
                if (matcher.matches()) {
                    String string = matcher.group(1);
                    return string;
                }
                log.warn((Object)("Can't parse output from " + javaCommand + " " + VERSION_CMD_OPTION));
                return null;
            }
            finally {
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

