/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.exception.DataAccessException;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.CommonsConfigUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.create.CustomizedXMLConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    private static final Logger log = Logger.getLogger(ConfigUtils.class);
    public static final String BAMBOO_DELIMITER_PARSING_DISABLED = "bambooDelimiterParsingDisabled";

    private ConfigUtils() {
    }

    public static void copyMapToConfig(@NotNull Map<String, String> map, @NotNull Configuration config) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            config.setProperty(key, (Object)value);
        }
    }

    public static void copyObjectMapToConfig(@NotNull Map<String, Object> map, @NotNull Configuration config) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            config.setProperty(key, value);
        }
    }

    @NotNull
    public static Map<String, String> asMap(@NotNull Configuration config, @Nullable String filter) {
        HashMap m = Maps.newHashMap();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (filter != null && !key.startsWith(filter)) continue;
            Object o = config.getProperty(key);
            if (o != null) {
                if (o instanceof String) {
                    m.put(key, (String)o);
                    continue;
                }
                log.warn((Object)("Non string object found in Build Configuration using .toString() representation. Key: " + key + ", Object Class: " + o.getClass()));
                m.put(key, o.toString());
                continue;
            }
            m.put(key, null);
        }
        return m;
    }

    public static Map<String, Object> asObjectMap(@NotNull Configuration config) {
        return ConfigUtils.asObjectMap(config, null);
    }

    @NotNull
    public static Map<String, Object> asObjectMap(@NotNull Configuration config, @Nullable String filter) {
        ImmutableMap.Builder answer = ImmutableMap.builder();
        for (String key : ConfigUtils.getKeys(config, filter)) {
            answer.put((Object)key, config.getProperty(key));
        }
        return answer.build();
    }

    @NotNull
    private static String[] getKeys(@NotNull Configuration config, @Nullable String filter) {
        Iterator keyIterator = filter != null ? config.getKeys(filter) : config.getKeys();
        return (String[])Iterators.toArray((Iterator)keyIterator, String.class);
    }

    public static void addNodesAt(HierarchicalConfiguration config, String rootPath, HierarchicalConfiguration configToAdd) {
        config.addNodes(rootPath, (Collection)configToAdd.getRoot().getChildren());
    }

    public static void addNodeAt(HierarchicalConfiguration configuration, String rootPath, HierarchicalConfiguration configToAdd) {
        configuration.addNodes(rootPath + "(-1)", (Collection)configToAdd.getRoot().getChildren());
    }

    public static void addMapToConfiguration(@NotNull String mapConfigKey, @NotNull String entryConfigKey, @NotNull Map<String, String> map, @NotNull HierarchicalConfiguration configuration) {
        String fullEntryKey = mapConfigKey + "." + entryConfigKey;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            configuration.addProperty(fullEntryKey + "(-1).key", (Object)entry.getKey());
            configuration.addProperty(fullEntryKey + ".value", (Object)value);
        }
    }

    public static void addMapToConfiguration(@NotNull String mapConfigKey, @NotNull Map<String, String> map, @NotNull HierarchicalConfiguration configuration) {
        ConfigUtils.addMapToConfiguration(mapConfigKey, "entry", map, configuration);
    }

    @Deprecated
    public static void addMapToBuilConfiguration(@NotNull String mapKey, @NotNull Map<String, String> map, @NotNull HierarchicalConfiguration configuration) {
        ConfigUtils.addMapToConfiguration(mapKey, map, configuration);
    }

    @NotNull
    public static Map<String, String> getMapFromConfiguration(@NotNull String mapConfigKey, @NotNull String entryConfigKey, @NotNull HierarchicalConfiguration configuration) {
        HashMap result = Maps.newHashMap();
        String fullEntryKey = mapConfigKey + "." + entryConfigKey;
        for (AbstractConfiguration configItem : Narrow.iterableTo(configuration.configurationsAt(fullEntryKey), AbstractConfiguration.class)) {
            result.put(configItem.getString("key"), configItem.getString("value"));
        }
        return result;
    }

    @NotNull
    public static Map<String, String> getMapFromConfiguration(@NotNull String mapConfigKey, @NotNull HierarchicalConfiguration configuration) {
        return ConfigUtils.getMapFromConfiguration(mapConfigKey, "entry", configuration);
    }

    @NotNull
    public static Map<String, String> toStringMap(@NotNull Map<String, ?> objectsMap) {
        HashMap<String, String> returnMap = new HashMap<String, String>(objectsMap.size());
        for (Map.Entry<String, ?> entry : objectsMap.entrySet()) {
            String key = entry.getKey();
            Object o = entry.getValue();
            if (o != null) {
                returnMap.put(key, o.toString());
                continue;
            }
            returnMap.put(key, null);
        }
        return returnMap;
    }

    @NotNull
    public static Map<String, Long> toLongMap(@NotNull Map<String, String> stringMap) throws NumberFormatException {
        HashMap<String, Long> returnMap = new HashMap<String, Long>(stringMap.size());
        for (Map.Entry<String, String> entry : stringMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value != null) {
                returnMap.put(key, Long.parseLong(value));
                continue;
            }
            returnMap.put(key, null);
        }
        return returnMap;
    }

    @Deprecated
    public static void sanitiseAndSave(@NotNull XMLConfiguration configuration, @NotNull Writer buildXml) throws ConfigurationException {
        CommonsConfigUtils.sanitiseAndSave(configuration, buildXml);
    }

    public static String asXmlString(@NotNull HierarchicalConfiguration hierarchicalConfiguration) {
        return ConfigUtils.asXmlString(ConfigUtils.newConfiguration(hierarchicalConfiguration));
    }

    @NotNull
    public static String asXmlString(@NotNull XMLConfiguration configuration) {
        CommonsConfigUtils.setDelimiterProcessingDisabled((AbstractConfiguration)configuration, true);
        StringWriter xmlWriter = new StringWriter();
        try {
            CommonsConfigUtils.setSpacePreserve(configuration);
            ConfigUtils.sanitiseAndSave(configuration, xmlWriter);
        }
        catch (ConfigurationException e) {
            log.error((Object)"Failed to write configuration as XML", (Throwable)e);
            throw new DataAccessException(e);
        }
        String configInXml = xmlWriter.toString();
        ConfigUtils.getXmlConfigFromXmlString(configInXml);
        return configInXml;
    }

    @NotNull
    public static XMLConfiguration getXmlConfigFromXmlString(@NotNull String xmlData) {
        return ConfigUtils.getXmlConfigFromXmlString(xmlData, true);
    }

    @Deprecated
    @NotNull
    public static XMLConfiguration getXmlConfigFromXmlString(@NotNull String xmlData, boolean delimiterParsingDisabled) {
        XMLConfiguration xmlConfiguration;
        if (xmlData.contains(BAMBOO_DELIMITER_PARSING_DISABLED)) {
            delimiterParsingDisabled = true;
        }
        try {
            xmlConfiguration = ConfigUtils.newConfiguration(delimiterParsingDisabled);
            xmlConfiguration.load((Reader)new StringReader(xmlData));
            CommonsConfigUtils.trim((HierarchicalConfiguration)xmlConfiguration);
        }
        catch (ConfigurationException e) {
            log.error((Object)("Error getting Build Configuration from '" + xmlData + "'."), (Throwable)e);
            throw new DataAccessException(e);
        }
        return xmlConfiguration;
    }

    public static void copyNodes(@NotNull HierarchicalConfiguration sourceConfig, @NotNull HierarchicalConfiguration targetConfig) {
        ConfigUtils.copyNodes(sourceConfig, targetConfig, null);
    }

    public static void copyNodes(@NotNull HierarchicalConfiguration sourceConfig, @NotNull HierarchicalConfiguration targetConfig, @Nullable String key) {
        targetConfig.addNodes(key, (Collection)((HierarchicalConfiguration)sourceConfig.clone()).getRootNode().getChildren());
    }

    public static XMLConfiguration newConfiguration() {
        return ConfigUtils.newConfiguration(true);
    }

    public static XMLConfiguration newConfiguration(boolean isDelimiterParsingDisabled) {
        CustomizedXMLConfiguration xmlConfiguration = new CustomizedXMLConfiguration();
        CommonsConfigUtils.setDelimiterProcessingDisabled((AbstractConfiguration)xmlConfiguration, isDelimiterParsingDisabled);
        return xmlConfiguration;
    }

    public static XMLConfiguration newConfiguration(HierarchicalConfiguration configuration) {
        CustomizedXMLConfiguration xmlConfiguration = new CustomizedXMLConfiguration(configuration);
        CommonsConfigUtils.setDelimiterProcessingDisabled((AbstractConfiguration)xmlConfiguration, true);
        return xmlConfiguration;
    }
}

