/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.commonsconfig.BambooHierarchicalConfiguration;
import com.atlassian.bamboo.util.BambooXmlUtils;
import com.atlassian.bamboo.util.Narrow;
import java.io.Writer;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitorAdapter;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CommonsConfigUtils {
    private static final Logger log = Logger.getLogger(CommonsConfigUtils.class);
    private static final String ATTRIBUTE_XML_SPACE = "xml:space";
    private static final String ATTRIBUTE_XML_SPACE_PRESERVE = "preserve";
    private static final ConfigurationNodeVisitorAdapter XML_SANITISER = new ConfigurationNodeVisitorAdapter(){

        public void visitBeforeChildren(ConfigurationNode node) {
            this.sanitise(node);
        }

        private void sanitise(ConfigurationNode node) {
            String originalValue = Narrow.downTo(node.getValue(), String.class);
            if (originalValue == null) {
                return;
            }
            String sanitisedValue = BambooXmlUtils.sanitiseXml10(originalValue);
            if (sanitisedValue != originalValue) {
                log.warn((Object)("Removed invalid characters from XML data, old value:\n" + originalValue + "\n, new value:\n" + sanitisedValue));
                node.setValue((Object)sanitisedValue);
            }
        }
    };
    private static final ConfigurationNodeVisitorAdapter WHITESPACE_TRIMMER = new ConfigurationNodeVisitorAdapter(){

        public void visitBeforeChildren(ConfigurationNode node) {
            if (node.getChildrenCount() == 0) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)Narrow.downTo(node.getValue(), String.class))) {
                node.setValue(null);
            }
        }
    };

    static void setDelimiterProcessingDisabled(AbstractConfiguration configuration, boolean isDisabled) {
        configuration.setDelimiterParsingDisabled(isDisabled);
        if (isDisabled) {
            configuration.clearProperty("bambooDelimiterParsingDisabled");
            configuration.setProperty("bambooDelimiterParsingDisabled", (Object)"true");
            configuration.setListDelimiter('\uf8ff');
        }
    }

    public static void sanitiseAndSave(@NotNull XMLConfiguration configuration, @NotNull Writer writer) throws ConfigurationException {
        CommonsConfigUtils.trim((HierarchicalConfiguration)configuration);
        CommonsConfigUtils.sanitise(configuration);
        configuration.save(writer);
    }

    public static void copyContent(XMLConfiguration src, HierarchicalConfiguration dst) {
        dst.clear();
        ConfigurationNode srcRootNode = src.getRootNode();
        HierarchicalConfiguration.Node dstRootNode = (HierarchicalConfiguration.Node)dst.getRootNode();
        CommonsConfigUtils.copyAttributes(srcRootNode, dstRootNode);
        CommonsConfigUtils.copyContent(srcRootNode, dstRootNode);
    }

    private static void copyContent(ConfigurationNode curSrcNode, HierarchicalConfiguration.Node curDstNode) {
        for (ConfigurationNode srcChild : curSrcNode.getChildren()) {
            HierarchicalConfiguration.Node dstChild = CommonsConfigUtils.cloneNode(srcChild);
            curDstNode.addChild(dstChild);
            CommonsConfigUtils.copyContent(srcChild, dstChild);
        }
    }

    private static HierarchicalConfiguration.Node cloneNode(ConfigurationNode node) {
        HierarchicalConfiguration.Node dstChild = new HierarchicalConfiguration.Node(node.getName(), node.getValue());
        CommonsConfigUtils.copyAttributes(node, dstChild);
        return dstChild;
    }

    private static void copyAttributes(ConfigurationNode src, HierarchicalConfiguration.Node dst) {
        for (ConfigurationNode attr : src.getAttributes()) {
            dst.addAttribute((ConfigurationNode)new DefaultConfigurationNode(attr.getName(), attr.getValue()));
        }
    }

    public static HierarchicalConfiguration newHierarchicalConfiguration() {
        BambooHierarchicalConfiguration configuration = new BambooHierarchicalConfiguration();
        CommonsConfigUtils.setDelimiterProcessingDisabled((AbstractConfiguration)configuration, true);
        return configuration;
    }

    public static HierarchicalConfiguration asHierarchicalConfiguration(XMLConfiguration xmlConfiguration) {
        HierarchicalConfiguration hierarchicalConfiguration = CommonsConfigUtils.newHierarchicalConfiguration();
        CommonsConfigUtils.copyContent(xmlConfiguration, hierarchicalConfiguration);
        return hierarchicalConfiguration;
    }

    static void setSpacePreserve(@NotNull XMLConfiguration configuration) {
        ConfigurationNode rootNode = configuration.getRootNode();
        HierarchicalConfiguration.Node attribute = new HierarchicalConfiguration.Node(ATTRIBUTE_XML_SPACE, (Object)ATTRIBUTE_XML_SPACE_PRESERVE);
        rootNode.removeAttribute(ATTRIBUTE_XML_SPACE);
        rootNode.addAttribute((ConfigurationNode)attribute);
    }

    private static void sanitise(@NotNull XMLConfiguration configuration) {
        configuration.getRootNode().visit((ConfigurationNodeVisitor)XML_SANITISER);
    }

    static void trim(HierarchicalConfiguration configuration) {
        configuration.getRootNode().visit((ConfigurationNodeVisitor)WHITESPACE_TRIMMER);
    }
}

