/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlUtils {
    private static final Logger log = Logger.getLogger(UrlUtils.class);
    private static final Pattern XSS_RELATED_CHARACTERS_REGEX = Pattern.compile("[\"'<>\\\\]");
    private static final String SCHEME_DELIMITER = "://";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";

    private UrlUtils() {
    }

    @NotNull
    public static String sanitizeUri(@NotNull String uri) {
        return XSS_RELATED_CHARACTERS_REGEX.matcher(uri).replaceAll("");
    }

    @Nullable
    public static String replaceOrInsertParamValue(String queryString, String newParamValue) {
        if (queryString == null) {
            return null;
        }
        if (!queryString.contains("buildNumber=")) {
            queryString = queryString.contains("?") ? (queryString.endsWith("&") ? queryString + "buildNumber=" + newParamValue : queryString + "&buildNumber=" + newParamValue) : queryString + "?buildNumber=" + newParamValue;
            return queryString;
        }
        return queryString.replaceAll("buildNumber=[0-9]*", "buildNumber=" + newParamValue);
    }

    public static String replacePlanResultKeyInUrl(String url, PlanKey planKey, int newBuildNumber) {
        return url.replaceFirst(planKey + "-[0-9]+", PlanKeys.getPlanResultKey(planKey, newBuildNumber).getKey());
    }

    public static String correctlyFormatUrl(String host) {
        if (host == null) {
            return null;
        }
        if (StringUtils.isBlank((String)host)) {
            return host;
        }
        StringBuffer urlToReturn = new StringBuffer(host);
        if (!host.startsWith("http://") && !host.startsWith("https://")) {
            urlToReturn.insert(0, "http://");
        }
        while (urlToReturn.charAt(urlToReturn.length() - 1) == '/') {
            urlToReturn.deleteCharAt(urlToReturn.length() - 1);
        }
        return urlToReturn.toString();
    }

    @NotNull
    public static String stripLeadingSlashes(@Nullable String toStrip) {
        int i;
        if (toStrip == null) {
            return "";
        }
        for (i = 0; toStrip.length() > i && '/' == toStrip.charAt(i); ++i) {
        }
        return toStrip.substring(i);
    }

    @NotNull
    public static String stripTailingSlashes(@Nullable String toStrip) {
        while (toStrip != null && toStrip.endsWith("/")) {
            toStrip = toStrip.replaceAll("/$", "");
        }
        if (toStrip == null) {
            return "";
        }
        return toStrip;
    }

    @NotNull
    public static String appendSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.endsWith("/")) {
            return theString + "/";
        }
        return theString;
    }

    @NotNull
    public static String prependSlashIfDoesntExist(@Nullable String theString) {
        if (theString == null) {
            return "/";
        }
        if (!theString.startsWith("/")) {
            return "/" + theString;
        }
        return theString;
    }

    public static String getPathUnderContext(@NotNull String url, @NotNull String context) {
        String path;
        int pathStart;
        if (url.startsWith("/")) {
            return StringUtils.removeStart((String)url, (String)context);
        }
        int urlSchemeEnd = url.indexOf(SCHEME_DELIMITER);
        if (urlSchemeEnd > 0) {
            urlSchemeEnd += SCHEME_DELIMITER.length();
        }
        int n = pathStart = urlSchemeEnd > 0 ? url.indexOf(47, urlSchemeEnd) : 0;
        if (pathStart > 0 && (path = url.substring(pathStart)).startsWith(context)) {
            return StringUtils.removeStart((String)path, (String)context);
        }
        return url;
    }

    @NotNull
    public static Multimap<String, String> extractQueryParams(@NotNull URL url) {
        HashMultimap params = HashMultimap.create();
        String query = (String)Preconditions.checkNotNull((Object)url.getQuery(), (String)"Expected that url '%s' will contain query part", (Object[])new Object[]{url});
        for (String queryPart : Splitter.on((String)"&").split((CharSequence)query)) {
            params.put((Object)StringUtils.substringBefore((String)queryPart, (String)"="), (Object)StringUtils.substringAfter((String)queryPart, (String)"="));
        }
        return params;
    }

    @Nullable
    public static String extractSingleQueryParam(@NotNull URL url, @NotNull String paramName) {
        Multimap<String, String> allParams = UrlUtils.extractQueryParams(url);
        Collection matchingParams = allParams.get((Object)paramName);
        Preconditions.checkArgument((matchingParams.size() <= 1 ? 1 : 0) != 0, (Object)String.format("Expected single '%s' parameter in query", paramName));
        return (String)Iterables.getFirst((Iterable)matchingParams, null);
    }

    @Nullable
    public static String extractSingleQueryParam(@NotNull String url, @NotNull String paramName) {
        try {
            return UrlUtils.extractSingleQueryParam(new URL(url), paramName);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static boolean isSameOrigin(@NotNull URL url, @NotNull URL origin) {
        return origin.getProtocol().equals(url.getProtocol()) && origin.getPort() == url.getPort() && origin.getHost().equalsIgnoreCase(url.getHost());
    }

    public static URL createUrl(@NotNull String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw BambooObjectUtils.asRuntimeException(e);
        }
    }

    public static URL createUrl(@NotNull String context, @NotNull String formActionDestination) {
        URL contextUrl = UrlUtils.createUrl(context);
        try {
            return new URL(contextUrl, formActionDestination);
        }
        catch (MalformedURLException e) {
            throw BambooObjectUtils.asRuntimeException(e);
        }
    }

    public static String constructBaseUrl(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        String scheme = request.getScheme();
        sb.append(scheme);
        sb.append(SCHEME_DELIMITER);
        sb.append(request.getServerName());
        int port = request.getServerPort();
        if (!UrlUtils.isStandardPort(scheme, port)) {
            sb.append(":");
            sb.append(port);
        }
        sb.append(request.getContextPath());
        return sb.toString();
    }

    private static boolean isStandardPort(String scheme, int port) {
        if (scheme.equalsIgnoreCase(HTTP_SCHEME) && port == 80) {
            return true;
        }
        return scheme.equalsIgnoreCase(HTTPS_SCHEME) && port == 443;
    }
}

