/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.spring.container.LazyComponentReference;
import com.opensymphony.xwork2.TextProvider;
import java.io.Serializable;
import org.apache.commons.lang.StringEscapeUtils;

public final class TextProviderUtils {
    private static final String TEXT_PROVIDER_BEAN_ID = "textProvider";
    static LazyComponentReference<TextProvider> textProvider = new LazyComponentReference("textProvider");

    private TextProviderUtils() {
    }

    public static String getText(TextProvider textProvider, String msg, String ... params) {
        return textProvider.getText(msg, params);
    }

    public static String getText(I18nResolver i18nResolver, String msg, String ... params) {
        return i18nResolver.getText(msg, (Serializable[])params);
    }

    public static String getHtml(TextProvider textProvider, String msg, String ... params) {
        String[] escapedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            escapedParams[i] = StringEscapeUtils.escapeHtml((String)params[i]);
        }
        return textProvider.getText(msg, escapedParams);
    }

    public static String getHtml(I18nResolver i18nResolver, String msg, String ... params) {
        String[] escapedParams = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            escapedParams[i] = StringEscapeUtils.escapeHtml((String)params[i]);
        }
        return i18nResolver.getText(msg, (Serializable[])escapedParams);
    }

    public static TextProvider getTextProvider() {
        return (TextProvider)textProvider.get();
    }

    public static String getText(String i18nKey) {
        return TextProviderUtils.getTextProvider().getText(i18nKey);
    }
}

