/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableDefinition;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableSubstitutionContext;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordMaskingUtils {
    public static final String PASSWORD_MASK = "********";
    public static final String PASSWORD_FIELD_NAME = "password";
    private static final Function<? extends VariableDefinitionContext, ? extends VariableDefinitionContext> MASK_VARIABLE_IF_NEEDED = new Function<VariableDefinitionContext, VariableDefinitionContext>(){

        public VariableDefinitionContext apply(VariableDefinitionContext input) {
            if (PasswordMaskingUtils.shouldBeMasked(input)) {
                input.setValue(PasswordMaskingUtils.PASSWORD_MASK);
                VariableDefinition vd = Narrow.downTo(input, VariableDefinition.class);
                if (vd != null) {
                    vd.setId(-vd.getId());
                }
            }
            return input;
        }
    };
    public static Predicate<VariableDefinitionContext> SHOULD_VARIABLE_BE_MASKED = new Predicate<VariableDefinitionContext>(){

        public boolean apply(VariableDefinitionContext variable) {
            return PasswordMaskingUtils.shouldBeMasked(variable.getKey());
        }
    };

    private PasswordMaskingUtils() {
    }

    public static boolean isMasked(@Nullable String value) {
        return PASSWORD_MASK.equals(value);
    }

    public static boolean shouldBeMasked(@Nullable String variableName) {
        return StringUtils.containsIgnoreCase((String)variableName, (String)PASSWORD_FIELD_NAME);
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinition variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableDefinitionContext variableDefinition) {
        return PasswordMaskingUtils.shouldBeMasked(variableDefinition.getKey());
    }

    public static boolean shouldBeMasked(@NotNull VariableSubstitutionContext variableSubstitutionContext) {
        return PasswordMaskingUtils.shouldBeMasked(variableSubstitutionContext.getKey());
    }

    public static boolean shouldIgnoreValue(String key, String value) {
        return PasswordMaskingUtils.shouldBeMasked(key) && PasswordMaskingUtils.isMasked(value);
    }

    public static <T extends VariableDefinitionContext> Collection<? extends T> maskPasswordValues(@NotNull Collection<T> variables, @NotNull Function<? super T, ? extends T> clone) {
        return Collections2.transform(variables, (Function)Functions.compose(MASK_VARIABLE_IF_NEEDED, clone));
    }

    public static String mask(@NotNull String string, @Nullable String password) {
        if (StringUtils.isEmpty((String)password)) {
            return string;
        }
        String encodedPassword = HtmlUtils.encodeUrl(password);
        return string.replace(password, PASSWORD_MASK).replace(encodedPassword, PASSWORD_MASK);
    }

    public static Iterable<String> findPossiblePasswordValues(Collection<VariableDefinitionContext> variables) {
        ArrayList possiblePasswordValues = Lists.newArrayList();
        for (VariableDefinitionContext variableDefinitionContext : variables) {
            if (!PasswordMaskingUtils.shouldBeMasked(variableDefinitionContext.getKey())) continue;
            possiblePasswordValues.add(variableDefinitionContext.getValue());
        }
        return possiblePasswordValues;
    }

    @Deprecated
    public static String maskPossiblePasswordValues(String text, Collection<VariableDefinitionContext> variables) {
        for (String pass : PasswordMaskingUtils.findPossiblePasswordValues(variables)) {
            if (!StringUtils.isNotBlank((String)pass) || !text.contains(pass)) continue;
            text = PasswordMaskingUtils.mask(text, pass);
        }
        return text;
    }

    public static String maskPossiblePasswordValues(String text, VariableContext variableContext) {
        for (VariableDefinitionContext pass : variableContext.getPasswordVariables()) {
            if (!StringUtils.isNotBlank((String)pass.getValue()) || !text.contains(pass.getValue())) continue;
            text = PasswordMaskingUtils.mask(text, pass.getValue());
        }
        return text;
    }
}

