/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.security.random.DefaultSecureRandomService;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumberUtils {
    private static final Logger log = Logger.getLogger(NumberUtils.class);
    private static final NumberUtils INSTANCE = new NumberUtils();

    private NumberUtils() {
    }

    public static NumberUtils getInstance() {
        return INSTANCE;
    }

    public static long randomNonNegativeLong() {
        long randomLong = DefaultSecureRandomService.getInstance().nextLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static double round(double val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static float round(float val, int places) {
        return (float)NumberUtils.round((double)val, places);
    }

    public static String padWithZeroes(Number value, int numberOfZeroes) {
        String pattern = NumberUtils.getPattern(numberOfZeroes);
        DecimalFormat stringNumberFormat = new DecimalFormat(pattern);
        return stringNumberFormat.format(value);
    }

    private static String getPattern(int numberOfZeroes) {
        return StringUtils.repeat((String)"0", (int)numberOfZeroes) + ".0#####";
    }

    @Deprecated
    public static double stringToDouble(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).doubleValue();
            }
            return 0.0;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0.0;
        }
    }

    @Nullable
    public static Double createDoubleQuietly(@Nullable String s) {
        try {
            return org.apache.commons.lang.math.NumberUtils.createDouble((String)s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static double unlocalizedStringToDouble(@Nullable String s) {
        try {
            return Double.valueOf(StringUtils.defaultIfEmpty((String)s, (String)"0"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)e, (Throwable)e);
            return 0.0;
        }
    }

    public static long stringToLong(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).longValue();
            }
            return 0L;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0L;
        }
    }

    public static int stringToInt(String s) {
        try {
            if (s != null) {
                return NumberFormat.getInstance().parse(s).intValue();
            }
            return 0;
        }
        catch (ParseException e) {
            log.warn((Object)e, (Throwable)e);
            return 0;
        }
    }

    public static <T extends Comparable<? super T>> T max(@NotNull Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Collection cannot be empty.");
        }
        Comparable max = null;
        for (Comparable number : collection) {
            if (max != null && number.compareTo(max) <= 0) continue;
            max = number;
        }
        return (T)max;
    }

    public static boolean isPositiveInteger(@Nullable String input) {
        if (StringUtils.startsWith((String)input, (String)"+")) {
            return false;
        }
        return org.apache.commons.lang.math.NumberUtils.toInt((String)input, (int)org.apache.commons.lang.math.NumberUtils.INTEGER_MINUS_ONE) > 0;
    }

    public static void arrayStore(int number, @NotNull byte[] array, int startIndex) {
        array[startIndex] = (byte)number;
        array[++startIndex] = (byte)(number >>> 8);
        array[++startIndex] = (byte)(number >>> 16);
        array[++startIndex] = (byte)(number >>> 24);
    }

    public static void arrayStore(long number, @NotNull byte[] array, int startIndex) {
        array[startIndex] = (byte)number;
        array[++startIndex] = (byte)(number >>> 8);
        array[++startIndex] = (byte)(number >>> 16);
        array[++startIndex] = (byte)(number >>> 24);
        array[++startIndex] = (byte)(number >>> 32);
        array[++startIndex] = (byte)(number >>> 40);
        array[++startIndex] = (byte)(number >>> 48);
        array[++startIndex] = (byte)(number >>> 56);
    }

    public static long valueOf(Long l, long defaultValue) {
        return l != null ? l : defaultValue;
    }

    @Nullable
    public static Integer toInteger(@Nullable Number number) {
        return number == null ? null : Integer.valueOf(number.intValue());
    }
}

