/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Map;

public class BambooDebugUtils {
    private BambooDebugUtils() {
    }

    public static String getAllStackTraces() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> threadEntry : allStackTraces.entrySet()) {
            sb.append(threadEntry.getKey()).append("\n");
            Object[] stackTrace = threadEntry.getValue();
            if (stackTrace.length != 0) {
                sb.append("  at ").append(Joiner.on((String)"\n  at ").join(stackTrace));
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static void dumpHeap(File file) {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String pid = name.substring(0, name.indexOf("@"));
        if (file.exists()) {
            Preconditions.checkState((boolean)file.delete());
        }
        String[] cmd = new String[]{"jmap", "-dump:file=" + file, pid};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

