/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class BambooDateUtils {
    private static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    private static final String TIME_FORMAT_HH_MM_SS_SSS = "HH:mm:ss.SSS";
    private static final DateTimeFormatter PORTABLE_DATE_FORMATTER = DateTimeFormat.forPattern((String)"'portable' G yyyy-MM-dd HH:mm:ss.SSS Z").withLocale(Locale.ENGLISH);
    private static final DateTimeFormatter ISO_TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private static final Date THE_EPOCH = new Date(0L);
    private static final Date END_OF_THE_WORLD_AS_WE_KNOW_IT = new DateTime(0L).plus((ReadablePeriod)Period.years((int)130)).toDate();

    private BambooDateUtils() {
    }

    public static boolean isWithinDays(Date earlierDate, Date laterDate, long days) {
        long daysDifference = (laterDate.getTime() - earlierDate.getTime()) / 86400000L;
        if (daysDifference < 0L) {
            throw new IllegalArgumentException("LaterDate must be later than the first date");
        }
        return daysDifference < days;
    }

    public static boolean isWithinMillis(@Nullable Date date1, @Nullable Date date2, long millis) {
        if (date1 == null || date2 == null) {
            return false;
        }
        return Math.abs(date2.getTime() - date1.getTime()) <= millis;
    }

    public static String dateToPortableString(@NotNull Date date) {
        return PORTABLE_DATE_FORMATTER.print(date.getTime());
    }

    public static String dateToPortableString(@NotNull Date date, @NotNull TimeZone timeZone) {
        return PORTABLE_DATE_FORMATTER.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone)).print(date.getTime());
    }

    public static Date portableDateStringToDate(@NotNull String dateString) throws ParseException {
        try {
            return PORTABLE_DATE_FORMATTER.parseDateTime(dateString).toDate();
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), dateString.length());
        }
    }

    public static long getMinutesDistanceToNow(@NotNull Date dateToCompare) {
        return BambooDateUtils.getMillisDistanceToNow(dateToCompare) / 60000L;
    }

    public static long getSecondsDistanceToNow(@NotNull Date dateToCompare) {
        return TimeUnit.MILLISECONDS.toSeconds(BambooDateUtils.getMillisDistanceToNow(dateToCompare));
    }

    public static long getMillisDistanceToNow(@NotNull Date dateToCompare) {
        return new Date().getTime() - dateToCompare.getTime();
    }

    @NotNull
    public static String toIsoTimestampString(@NotNull Date date) {
        return ISO_TIMESTAMP_FORMATTER.print(date.getTime());
    }

    @NotNull
    public static Date fromIsoTimestampString(@NotNull String dateString) {
        return ISO_TIMESTAMP_FORMATTER.parseDateTime(dateString).toDate();
    }

    public static Date makeReasonableDate(@NotNull Date date) {
        Date notTooEarly = THE_EPOCH.after(date) ? THE_EPOCH : date;
        return notTooEarly.after(END_OF_THE_WORLD_AS_WE_KNOW_IT) ? END_OF_THE_WORLD_AS_WE_KNOW_IT : notTooEarly;
    }
}

