/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import java.io.Serializable;
import java.security.Key;
import java.security.KeyPair;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class BambooCurrentApplication
implements Comparable<BambooCurrentApplication>,
Serializable {
    private final String applicationId;
    private final KeyPair keyPair;

    public BambooCurrentApplication(String applicationId, KeyPair keyPair) {
        this.applicationId = applicationId;
        this.keyPair = keyPair;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    @Deprecated
    public String getPublicKey() {
        return BambooCurrentApplication.encode(this.keyPair.getPublic());
    }

    @Deprecated
    public String getPrivateKey() {
        return BambooCurrentApplication.encode(this.keyPair.getPrivate());
    }

    private static String encode(Key key) {
        return Base64.encodeBase64String((byte[])key.getEncoded());
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.applicationId).append((Object)this.keyPair).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BambooCurrentApplication)) {
            return false;
        }
        BambooCurrentApplication rhs = (BambooCurrentApplication)o;
        return new EqualsBuilder().append((Object)this.applicationId, (Object)rhs.applicationId).append((Object)this.keyPair.getPublic(), (Object)rhs.keyPair.getPublic()).append((Object)this.keyPair.getPrivate(), (Object)rhs.keyPair.getPrivate()).isEquals();
    }

    @Override
    public int compareTo(BambooCurrentApplication o) {
        return new CompareToBuilder().append((Object)this.applicationId, (Object)o.applicationId).append((Object)this.keyPair.getPublic(), (Object)o.keyPair.getPrivate()).append((Object)this.keyPair.getPrivate(), (Object)o.keyPair.getPrivate()).toComparison();
    }
}

