/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestQuarantineHelper {
    private static final String QUARANTINE_TEST_KEY = "bamboo.system.getTestsToPass";
    private static final String TEST_CASE_SEPARATOR = "xXSePXxxXSePXx";
    private static final String TEST_CASE_INNER_SEPARATOR = "xXSePXx";
    private static final Function<TestCase, String> TEST_CASE_TO_STRING = new Function<TestCase, String>(){

        public String apply(TestCase testCase) {
            return TestQuarantineHelper.testToString(testCase.getName(), testCase.getTestClass().getName());
        }
    };
    private static final Function<TestResults, String> TEST_RESULTS_TO_STRING = new Function<TestResults, String>(){

        public String apply(TestResults testResult) {
            return TestQuarantineHelper.testToString(testResult.getActualMethodName(), testResult.getClassName());
        }
    };

    private TestQuarantineHelper() {
    }

    public static void put(ImmutableMap.Builder<String, String> customBuildDataBuilder, List<TestCase> quarantinedTests) {
        List quarantinedTestsNames = Lists.transform(quarantinedTests, TEST_CASE_TO_STRING);
        customBuildDataBuilder.put((Object)QUARANTINE_TEST_KEY, (Object)StringUtils.join((Collection)quarantinedTestsNames, (String)TEST_CASE_SEPARATOR));
    }

    public static void remove(Map<String, ?> customBuildData) {
        customBuildData.remove(QUARANTINE_TEST_KEY);
    }

    @NotNull
    public static Set<String> getQuarantinedTests(Map<String, String> map) {
        String unparsedQuarantineData = TestQuarantineHelper.getUnparsedQuarantineData(map);
        if (unparsedQuarantineData == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet(TestQuarantineHelper.getUnparsedQuarantinedTests(unparsedQuarantineData));
    }

    public static boolean containsAll(Set<String> quarantinedTests, Collection<TestResults> failedTests) {
        return quarantinedTests.containsAll(Collections2.transform(failedTests, TEST_RESULTS_TO_STRING));
    }

    public static boolean contains(Set<String> quarantinedTests, TestCase testCase) {
        return quarantinedTests.contains(TEST_CASE_TO_STRING.apply((Object)testCase));
    }

    @Nullable
    private static String getUnparsedQuarantineData(Map<String, String> map) {
        return map.get(QUARANTINE_TEST_KEY);
    }

    private static Iterable<String> getUnparsedQuarantinedTests(String unparsedQuarantineData) {
        return Splitter.on((String)TEST_CASE_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)unparsedQuarantineData);
    }

    static String testToString(String testName, String testClassName) {
        return testName.trim() + TEST_CASE_INNER_SEPARATOR + testClassName.trim();
    }
}

