/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.plan.PlanKey;
import com.google.common.base.Objects;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
@PublicApi
public final class PlanResultKey
implements ResultKey,
Serializable {
    private final PlanKey planKey;
    private final int buildNumber;

    PlanResultKey(@NotNull PlanKey planKey, int buildNumber) {
        this.planKey = planKey;
        this.buildNumber = buildNumber;
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @Override
    @NotNull
    public Key getEntityKey() {
        return this.planKey;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public int getResultNumber() {
        return this.buildNumber;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.planKey.getKey() + "-" + this.getBuildNumber();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlanResultKey)) {
            return false;
        }
        PlanResultKey resultKey = (PlanResultKey)o;
        return this.buildNumber == resultKey.buildNumber && Objects.equal((Object)this.planKey, (Object)resultKey.planKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.planKey, this.buildNumber});
    }

    public String toString() {
        return this.getKey();
    }
}

