/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public final class PlanKeys {
    public static final char SEP = '-';
    static final String DELETED_PREFIX = "DELETED_";
    public static Function<? super PlanResultKey, ? extends PlanResultKey> REMOVE_DELETION_MARKER = new Function<PlanResultKey, PlanResultKey>(){

        public PlanResultKey apply(PlanResultKey deletedKey) {
            return PlanKeys.getPlanResultKey(PlanKeys.asNonDeletedPlanKey(deletedKey.getPlanKey()), deletedKey.getResultNumber());
        }
    };
    public static Function<PlanKey, String> planKeyToKey = new Function<PlanKey, String>(){

        public String apply(@Nullable PlanKey input) {
            return ((PlanKey)Preconditions.checkNotNull((Object)input, (Object)"Input key cannot be null")).getKey();
        }
    };
    private static Function<PlanResultKey, String> planKeyStringFromPlanResultKey = Functions.compose(planKeyToKey, PlanKeys.planKeyFromPlanResultKey());
    public static Function<? super PlanResultKey, ? extends PlanResultKey> chainResultKeyFromJobResultKey = new Function<PlanResultKey, PlanResultKey>(){

        public PlanResultKey apply(@Nullable PlanResultKey input) {
            return PlanKeys.getChainResultKey(input);
        }
    };
    private static final Function<String, PlanKey> planKeyFromString = new Function<String, PlanKey>(){

        public PlanKey apply(@Nullable String input) {
            Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input string cannot be null");
            return PlanKeys.getPlanKey(input);
        }
    };
    private static final Function<String, PlanResultKey> planResultKeyFromString = new Function<String, PlanResultKey>(){

        public PlanResultKey apply(@Nullable String input) {
            Preconditions.checkArgument((input != null ? 1 : 0) != 0, (Object)"Input string cannot be null");
            return PlanKeys.getPlanResultKey(input);
        }
    };
    public static final Function<PlanKey, PlanKey> CHAIN_KEY_FROM_JOB_KEY = new Function<PlanKey, PlanKey>(){

        public PlanKey apply(@NotNull PlanKey jobKey) {
            String[] parts = PlanKeys.splitJobKey(jobKey);
            return PlanKeys.getPlanKey(parts[0], parts[1]);
        }
    };
    public static final Function<PlanKey, String> PARTIAL_JOB_KEY_FROM_JOB_KEY = new Function<PlanKey, String>(){

        public String apply(@NotNull PlanKey jobKey) {
            String[] parts = PlanKeys.splitJobKey(jobKey);
            return parts[2];
        }
    };
    public static final Comparator<PlanKey> PLAN_KEY_COMPARATOR = new Comparator<PlanKey>(){

        @Override
        public int compare(PlanKey o1, PlanKey o2) {
            if (o1 == null || o2 == null) {
                return o1 == o2 ? 0 : (o1 == null ? -1 : 1);
            }
            return new CompareToBuilder().append((Object)o1.getKey(), (Object)o2.getKey()).toComparison();
        }
    };
    public static final Function<PlanKey, String> SHORT_KEY_FROM_PLAN_KEY = new Function<PlanKey, String>(){

        public String apply(@Nullable PlanKey planKey) {
            String[] parts = StringUtils.split((String)planKey.getKey(), (char)'-');
            return parts[parts.length - 1];
        }
    };

    public static Function<PlanResultKey, PlanKey> planKeyFromPlanResultKey() {
        return PlanKeyFromPlanResultKey.INSTANCE;
    }

    public static Function<PlanResultKey, String> planKeyStringFromPlanResultKey() {
        return planKeyStringFromPlanResultKey;
    }

    public static Function<String, PlanKey> planKeyFromString() {
        return planKeyFromString;
    }

    public static Function<String, PlanResultKey> planResultKeyFromString() {
        return planResultKeyFromString;
    }

    public static Function<PlanKey, String> planKeyToString() {
        return planKeyToKey;
    }

    public static Function<PlanIdentifier, PlanKey> planKeyFromPlan() {
        return PlanIdentifier.getPlanKeyFunction;
    }

    private static String[] splitJobKey(@NotNull PlanKey jobKey) {
        String[] parts = StringUtils.split((String)jobKey.getKey(), (char)'-');
        Preconditions.checkArgument((parts.length == 3 ? 1 : 0) != 0, (String)"String [%s] is not a job key", (Object[])new Object[]{jobKey.getKey()});
        return parts;
    }

    private PlanKeys() {
    }

    public static boolean isChainKey(@NotNull PlanKey planKey) {
        return StringUtils.split((String)planKey.getKey(), (char)'-').length == 2;
    }

    public static boolean isJobKey(@NotNull PlanKey planKey) {
        return StringUtils.split((String)planKey.getKey(), (char)'-').length == 3;
    }

    public static PlanKey getPlanKey(@NotNull String projectKey, @NotNull String buildKey) {
        return PlanKeys.getPlanKey(projectKey + '-' + buildKey);
    }

    @Nullable
    public static String getProjectKeyPart(@NotNull PlanKey planKey) {
        String[] tokens = planKey.getKey().split(Character.toString('-'));
        return tokens.length > 0 ? tokens[0] : null;
    }

    @Nullable
    public static String getProjectKeyPart(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getProjectKeyPart(planResultKey.getPlanKey());
    }

    @NotNull
    public static String getPlanKeyPart(@NotNull PlanKey planKey) {
        String[] tokens = planKey.getKey().split(Character.toString('-'));
        if (tokens.length < 2) {
            throw new IllegalArgumentException("Invalid plan key: " + planKey);
        }
        return planKey.getKey().substring(tokens[0].length() + 1);
    }

    @Nullable
    public static String getPlanKeyPart(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getPlanKeyPart(planResultKey.getPlanKey());
    }

    @NotNull
    public static PlanKey getJobKey(@NotNull PlanKey chainPlanKey, @NotNull String jobKey) {
        if (StringUtils.contains((CharSequence)jobKey, (int)45)) {
            throw new IllegalArgumentException("Job key '" + jobKey + "' contains a '" + '-' + "'");
        }
        return new PlanKey(chainPlanKey.getKey() + '-' + jobKey);
    }

    @NotNull
    public static PlanKey getChainKeyFromJobKey(@NotNull PlanKey jobKey) {
        return (PlanKey)CHAIN_KEY_FROM_JOB_KEY.apply((Object)jobKey);
    }

    @Nullable
    public static PlanKey getChainKeyIfJobKey(@NotNull PlanKey jobKey) {
        try {
            return PlanKeys.getChainKeyFromJobKey(jobKey);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PlanKey getPlanKey(@NotNull String projectKey, @Nullable String chainKey, @NotNull String buildKey) {
        if (StringUtils.isBlank((CharSequence)chainKey)) {
            return PlanKeys.getPlanKey(projectKey + '-' + buildKey);
        }
        return PlanKeys.getPlanKey(projectKey + '-' + chainKey + '-' + buildKey);
    }

    @NotNull
    public static PlanKey getPlanKey(@NotNull String planKey) {
        String[] parts = StringUtils.split((String)planKey, (char)'-');
        if (parts == null || parts.length > 4 || parts.length < 2) {
            throw new IllegalArgumentException("Could not parse key '" + planKey + "'");
        }
        if (parts.length >= 3) {
            try {
                Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return new PlanKey(parts[0] + '-' + parts[1] + '-' + parts[2]);
            }
        }
        return new PlanKey(parts[0] + '-' + parts[1]);
    }

    public static PlanResultKey getPlanResultKey(String planResultKey) {
        return PlanKeys.parse(PlanKeys.getPlanKey(planResultKey), planResultKey);
    }

    public static PlanResultKey getPlanResultKey(@NotNull String planKey, int buildNumber) {
        PlanKey key = PlanKeys.getPlanKey(planKey);
        return new PlanResultKey(key, buildNumber);
    }

    public static PlanResultKey getPlanResultKey(PlanKey planKey, int buildNumber) {
        return new PlanResultKey(planKey, buildNumber);
    }

    @NotNull
    public static PlanResultKey getChainResultKey(@NotNull PlanResultKey planResultKey) {
        return PlanKeys.getPlanResultKey(PlanKeys.getChainKeyFromJobKey(planResultKey.getPlanKey()), planResultKey.getBuildNumber());
    }

    public static String getPartialJobKey(PlanKey jobKey) {
        return (String)PARTIAL_JOB_KEY_FROM_JOB_KEY.apply((Object)jobKey);
    }

    public static String getShortKeyFromPlanKey(PlanKey planKey) {
        return (String)SHORT_KEY_FROM_PLAN_KEY.apply((Object)planKey);
    }

    private static PlanResultKey parse(PlanKey planKey, String key) {
        Integer buildNumber;
        String numberPart;
        String[] parts = StringUtils.split((String)key, (char)'-');
        if (parts.length == 3) {
            numberPart = parts[2];
        } else if (parts.length == 4) {
            numberPart = parts[3];
        } else {
            throw new IllegalArgumentException("Could not parse key '" + key + "'");
        }
        try {
            buildNumber = Integer.parseInt(numberPart);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse build number part of key '" + key + "'");
        }
        return new PlanResultKey(planKey, buildNumber);
    }

    public static void assertSafeKey(String key) {
        if (key.contains("/") || key.contains("\\")) {
            throw new IllegalArgumentException("Illegal key: " + key);
        }
    }

    public static PlanKey updatePlanKeyInBranchKey(@NotNull PlanKey branchKey, @NotNull PlanKey originalPlanKey, @NotNull PlanKey newPlanKey) {
        if (StringUtils.startsWith((CharSequence)branchKey.getKey(), (CharSequence)originalPlanKey.getKey())) {
            return PlanKeys.getPlanKey(StringUtils.replaceOnce((String)branchKey.getKey(), (String)originalPlanKey.getKey(), (String)newPlanKey.getKey()));
        }
        return branchKey;
    }

    public static Option<Long> getBranchNumberSuffix(@NotNull PlanKey chainKey, @NotNull PlanKey branchKey) {
        String chainKeyString = chainKey.getKey();
        String branchKeyString = branchKey.getKey();
        if (StringUtils.startsWith((CharSequence)branchKeyString, (CharSequence)chainKeyString)) {
            String branchNumberSuffix = StringUtils.substringAfter((String)branchKeyString, (String)chainKeyString);
            if (branchNumberSuffix.isEmpty()) {
                return Option.none();
            }
            return Option.some((Object)Long.parseLong(branchNumberSuffix));
        }
        throw new IllegalArgumentException(String.format("Branch key %s does not start with chain key %s", branchKeyString, chainKeyString));
    }

    public static PlanKey asDeletedPlanKey(@NotNull PlanKey planKey) {
        String projectKey = PlanKeys.getProjectKeyPart(planKey);
        String planKeyPart = PlanKeys.getPlanKeyPart(planKey);
        return PlanKeys.getPlanKey(DELETED_PREFIX + projectKey, planKeyPart);
    }

    public static PlanKey asNonDeletedPlanKey(@NotNull PlanKey planKey) {
        String projectKey = PlanKeys.getProjectKeyPart(planKey);
        String planKeyPart = PlanKeys.getPlanKeyPart(planKey);
        return PlanKeys.getPlanKey(StringUtils.removeStart((String)projectKey, (String)DELETED_PREFIX), planKeyPart);
    }

    private static enum PlanKeyFromPlanResultKey implements Function<PlanResultKey, PlanKey>
    {
        INSTANCE;


        public PlanKey apply(@Nullable PlanResultKey input) {
            return ((PlanResultKey)Preconditions.checkNotNull((Object)input, (Object)"Input key cannot be null")).getPlanKey();
        }
    }
}

