/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.repository.RepositoryException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowableDetails
implements Serializable {
    private final String name;
    private final String message;
    private final String stackTrace;
    private final List<String> causeStack;
    private Long repositoryId;

    private ThrowableDetails(Throwable throwable) {
        this.name = throwable.getClass().getName();
        this.message = throwable.getMessage();
        this.stackTrace = ExceptionUtils.getFullStackTrace((Throwable)throwable);
        this.causeStack = this.generateCauseStack(throwable);
    }

    private List<String> generateCauseStack(@Nullable Throwable throwable) {
        ArrayList stack = Lists.newArrayList();
        while (throwable != null) {
            stack.add(throwable.getClass().getName());
            if (this.repositoryId == null && throwable instanceof RepositoryException) {
                this.repositoryId = ((RepositoryException)throwable).getRepositoryId();
            }
            if (throwable == throwable.getCause()) break;
            throwable = throwable.getCause();
        }
        return stack;
    }

    @Nullable
    public static ThrowableDetails fromThrowable(@Nullable Throwable throwable) {
        return throwable == null ? null : new ThrowableDetails(throwable);
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public Long getRepositoryId() {
        return this.repositoryId;
    }

    @NotNull
    public ImmutableList<String> getCauseStack() {
        return ImmutableList.copyOf(this.causeStack);
    }
}

