/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractErrorUpdateHandler
implements ErrorUpdateHandler {
    protected final AgentContext agentContext;

    protected AbstractErrorUpdateHandler(AgentContext agentContext) {
        this.agentContext = agentContext;
    }

    @Override
    public void recordError(@NotNull Key entityKey, @Nullable String context) {
        this.createError(entityKey.getKey(), null, this.getCurrentAgentId(), context, null);
    }

    @Override
    public void recordError(@NotNull Key entityKey, @Nullable String context, @NotNull Throwable throwable) {
        this.createError(entityKey.getKey(), null, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    public void recordError(@NotNull ResultKey resultKey, String context, @Nullable Throwable throwable) {
        this.createError(resultKey.getEntityKey().getKey(), resultKey.getResultNumber(), this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    public void recordError(String context) {
        this.recordError(context, null);
    }

    @Override
    public void recordError(String context, @Nullable Throwable throwable) {
        this.createError(null, -1, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    public void recordElasticError(String context, @Nullable Long agentId, @Nullable Throwable throwable, @Nullable String instanceId) {
        this.createElasticError(context, agentId, ThrowableDetails.fromThrowable(throwable), instanceId);
    }

    @Override
    public void addErrorCollection(ResultKey buildKey, ErrorCollection errors) {
        for (String errorMessage : errors.getErrorMessages()) {
            this.recordError(buildKey, errorMessage, null);
        }
    }

    @Nullable
    protected Long getCurrentAgentId() {
        ExecutableBuildAgent buildAgent = this.agentContext != null ? this.agentContext.getBuildAgent() : null;
        return buildAgent != null ? Long.valueOf(buildAgent.getId()) : null;
    }
}

