/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.expiry;

import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryType;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;

public class DeploymentExpiryConfig
implements Serializable {
    private static final Logger log = Logger.getLogger(DeploymentExpiryConfig.class);
    public static final long REMOVE_ALL_LOGS = -1L;
    public static final int MINIMUM_DEPLOYMENTS_TO_KEEP = 2;
    private final boolean expiryEnabled;
    private final EnumSet<DeploymentExpiryType> expiryTypes;
    private final Period expiryPeriod;
    private final int deploymentsToKeep;
    private final long maxIgnoredLogSize;

    DeploymentExpiryConfig(boolean expiryEnabled, Iterable<DeploymentExpiryType> expiryTypes, Period expiryPeriod, int deploymentsToKeep, long maxIgnoredLogSize) {
        this.expiryEnabled = expiryEnabled;
        this.expiryTypes = Sets.newEnumSet(expiryTypes, DeploymentExpiryType.class);
        this.expiryPeriod = expiryPeriod;
        this.deploymentsToKeep = deploymentsToKeep;
        this.maxIgnoredLogSize = maxIgnoredLogSize;
    }

    public boolean isExpiryEnabled() {
        return this.expiryEnabled;
    }

    @NotNull
    public Set<DeploymentExpiryType> getExpiryTypes() {
        return ImmutableSet.copyOf(this.expiryTypes);
    }

    public Period getExpiryPeriod() {
        return this.expiryPeriod;
    }

    public int getDeploymentsToKeep() {
        return this.deploymentsToKeep;
    }

    public long getMaxIgnoredLogSize() {
        return this.maxIgnoredLogSize;
    }

    public boolean shouldExpireDeploymentResultLogs() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_RESULT_LOG_EXPIRY);
    }

    public boolean shouldExpireDeploymentResults() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_RESULT_EXPIRY);
    }

    public boolean shouldExpireDeploymentVersionArtifacts() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_VERSION_ARTIFACTS_EXPIRY);
    }

    public boolean shouldExpireDeploymentVersions() {
        return this.expiryTypes.contains((Object)DeploymentExpiryType.DEPLOYMENT_VERSION_EXPIRY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentExpiryConfig that = (DeploymentExpiryConfig)o;
        return Objects.equal((Object)this.expiryEnabled, (Object)that.expiryEnabled) && Objects.equal(this.expiryTypes, that.expiryTypes) && Objects.equal((Object)this.expiryPeriod, (Object)that.expiryPeriod) && Objects.equal((Object)this.deploymentsToKeep, (Object)that.deploymentsToKeep) && Objects.equal((Object)this.maxIgnoredLogSize, (Object)that.maxIgnoredLogSize);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.expiryEnabled, this.expiryTypes, this.expiryPeriod, this.deploymentsToKeep, this.maxIgnoredLogSize});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("expiryEnabled", this.expiryEnabled).add("expiryTypes", this.expiryTypes).add("expiryPeriod", (Object)this.expiryPeriod).add("deploymentsToKeep", this.deploymentsToKeep).add("maxIgnoredLogSize", this.maxIgnoredLogSize).toString();
    }
}

