/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class LogMutatorStack
implements LogMutator {
    private final List<LogMutator> mutators = Lists.newArrayList();

    public synchronized void clear() {
        this.mutators.clear();
    }

    public synchronized void add(@NotNull LogMutator interceptor) {
        this.mutators.add(interceptor);
    }

    public synchronized void remove(@Nullable LogMutator interceptor) {
        this.mutators.remove(interceptor);
    }

    @Override
    public synchronized LogEntry mutate(@NotNull LogEntry logEntry) {
        for (LogMutator interceptor : this.mutators) {
            logEntry = interceptor.mutate(logEntry);
        }
        return logEntry;
    }

    @Override
    public synchronized LogEntry mutateError(@NotNull LogEntry logEntry) {
        for (LogMutator interceptor : this.mutators) {
            logEntry = interceptor.mutateError(logEntry);
        }
        return logEntry;
    }
}

