/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class FIFOBoundedList<E>
implements Collection<E>,
List<E> {
    private static final Logger log = Logger.getLogger(FIFOBoundedList.class);
    private final int maxSize;
    private final LinkedList<E> linkedList = new LinkedList();

    public FIFOBoundedList(int maxSize) {
        this.maxSize = maxSize;
    }

    public FIFOBoundedList() {
        this(500);
    }

    @Override
    public boolean add(E o) {
        boolean added = this.linkedList.add(o);
        this.trimToMax();
        return added;
    }

    private void trimToMax() {
        while (this.size() > this.maxSize()) {
            this.linkedList.removeFirst();
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean added = this.linkedList.addAll(c);
        this.trimToMax();
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean added = this.linkedList.addAll(index, c);
        this.trimToMax();
        return added;
    }

    @Override
    public E set(int index, E element) {
        return this.linkedList.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.linkedList.add(index, element);
        this.trimToMax();
    }

    public boolean isFull() {
        return this.size() >= this.maxSize();
    }

    public int maxSize() {
        return this.maxSize;
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.isEmpty();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.linkedList.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.linkedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.linkedList.retainAll(c);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.linkedList.listIterator();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.linkedList.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object o) {
        return this.linkedList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.linkedList.hashCode();
    }

    @Override
    public Iterator<E> iterator() {
        return this.linkedList.iterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.linkedList.contains(o);
    }

    @Override
    public int size() {
        return this.linkedList.size();
    }

    @Override
    public boolean remove(Object o) {
        return this.linkedList.remove(o);
    }

    @Override
    public void clear() {
        this.linkedList.clear();
    }

    @Override
    public E get(int index) {
        return this.linkedList.get(index);
    }

    @Override
    public E remove(int index) {
        return this.linkedList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.linkedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.linkedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.linkedList.listIterator(index);
    }

    @Override
    public Object[] toArray() {
        return this.linkedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.linkedList.toArray(a);
    }
}

