/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Internal
public class JarDescriptor {
    private final String name;
    private final InputSupplier<InputStream> inputSupplier;
    private final Supplier<Long> checksum = new LazyReference<Long>(){
        private static final int STREAM_BUFFER_LENGTH = 1024;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Long create() throws Exception {
            InputStream data = JarDescriptor.this.getInputStream();
            try {
                Adler32 checksum = new Adler32();
                byte[] buffer = new byte[1024];
                int read = data.read(buffer, 0, 1024);
                while (read > -1) {
                    checksum.update(buffer, 0, read);
                    read = data.read(buffer, 0, 1024);
                }
                Long l = checksum.getValue();
                return l;
            }
            finally {
                IOUtils.closeQuietly((InputStream)data);
            }
        }
    };

    public JarDescriptor(String name, InputSupplier<InputStream> inputSupplier) {
        this.name = name;
        this.inputSupplier = inputSupplier;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public long getChecksum() {
        return (Long)this.checksum.get();
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return (InputStream)this.inputSupplier.getInput();
    }

    @NotNull
    public FileHashDescriptor getFileHashDescriptor() {
        return new FileHashDescriptor(this.getName(), this.getChecksum());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarDescriptor that = (JarDescriptor)o;
        return this.name.equals(that.name) && ((Long)this.checksum.get()).equals(that.checksum.get());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

