/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.setup;

import com.atlassian.annotations.Internal;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

@Internal
public class ServerFingerprint
implements Serializable {
    private final String serverFingerprint;
    private final long instanceFingerprint;

    public ServerFingerprint(@NotNull String serverFingerprint, long instanceFingerprint) {
        this.serverFingerprint = serverFingerprint;
        this.instanceFingerprint = instanceFingerprint;
    }

    @NotNull
    public String getServerFingerprint() {
        return this.serverFingerprint;
    }

    public long getInstanceFingerprint() {
        return this.instanceFingerprint;
    }

    public boolean matchesServerFingerprint(@NotNull ServerFingerprint other) {
        return this.serverFingerprint.equals(other.getServerFingerprint());
    }

    public boolean matchesInstanceFingerprint(@NotNull ServerFingerprint other) {
        return this.instanceFingerprint == other.getInstanceFingerprint() && this.matchesServerFingerprint(other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerFingerprint that = (ServerFingerprint)o;
        if (this.instanceFingerprint != that.instanceFingerprint) {
            return false;
        }
        return this.serverFingerprint.equals(that.serverFingerprint);
    }

    public int hashCode() {
        int result = this.serverFingerprint.hashCode();
        result = 31 * result + (int)this.instanceFingerprint;
        return result;
    }

    public String toString() {
        return "Fingerprint[server: " + this.serverFingerprint + " run: " + this.instanceFingerprint + "]";
    }
}

