/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.index.Indexer;
import com.atlassian.bamboo.index.IndexerContext;
import com.atlassian.bamboo.index.IndexerService;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneException;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractIndexer
implements Indexer {
    private static final Logger log = Logger.getLogger(AbstractIndexer.class);
    private static final String BANDANA_APPROXIMATE_TIME_PER_RESULT = "approximateTimePerResult";
    private static final long GUESS_MILLIS_PER_RESULT = 100L;
    private Supplier<IndexerContext> defaultIndexerContext = new Supplier<IndexerContext>(){

        @Override
        public IndexerContext get() {
            return AbstractIndexer.this.indexerService.createNewIndexerContext(AbstractIndexer.this.luceneConnection);
        }
    };
    protected final ILuceneConnection luceneConnection;
    private final BandanaManager bandanaManager;
    private final int maxDbConnections;
    protected final IndexerService indexerService;

    protected AbstractIndexer(ILuceneConnection luceneConnection, BandanaManager bandanaManager, int maxDbConnections, IndexerService indexerService) {
        this.luceneConnection = luceneConnection;
        this.bandanaManager = bandanaManager;
        this.maxDbConnections = maxDbConnections;
        this.indexerService = indexerService;
    }

    @Override
    public void deleteIndex() {
        this.indexerService.recreateIndexDirectory(this.getDefaultIndexerContext());
    }

    @Override
    public int getNumberOfDocuments() {
        try {
            return this.luceneConnection.getNumDocs();
        }
        catch (LuceneException e) {
            log.warn((Object)"luceneConnection.getNumDocs() failed. Zero returned for number of docs", (Throwable)e);
            return 0;
        }
    }

    protected abstract BambooBandanaContext getIndexerBandanaContext();

    protected long getApproximateIndexingTimePerResult() {
        String bandanaKey;
        BambooBandanaContext bandanaContext = this.getIndexerBandanaContext();
        Long approximateTimePerResult = Narrow.to(this.bandanaManager.getValue((BandanaContext)bandanaContext, bandanaKey = this.getBandanaApproximateTimePerResultKey(bandanaContext)), Long.class);
        if (approximateTimePerResult != null) {
            return approximateTimePerResult;
        }
        log.info((Object)String.format("Can't find approximateTimePerResult value in Bandana for indexer %s, assuming default %sms", this.getClass().getName(), 100L));
        return 100L;
    }

    protected void updateApproximateIndexingTimePerResult(long totalIndexingTime, int entityCount) {
        if (entityCount > 0) {
            long indexingTimePerResult = totalIndexingTime / (long)entityCount;
            BambooBandanaContext bandanaContext = this.getIndexerBandanaContext();
            String bandanaKey = this.getBandanaApproximateTimePerResultKey(bandanaContext);
            this.bandanaManager.setValue((BandanaContext)bandanaContext, bandanaKey, (Object)indexingTimePerResult);
        }
    }

    private String getBandanaApproximateTimePerResultKey(@NotNull BambooBandanaContext bandanaContext) {
        return bandanaContext.getPluginKey() + ":" + BANDANA_APPROXIMATE_TIME_PER_RESULT;
    }

    protected int getConcurrentIndexers() {
        int maxThreads = Math.max(Runtime.getRuntime().availableProcessors() / 4, 1);
        return Math.min(this.maxDbConnections, maxThreads);
    }

    @NotNull
    protected IndexerContext getDefaultIndexerContext() {
        return this.defaultIndexerContext.get();
    }

    @NotNull
    protected IndexerContext lockIndexerQueue() {
        return this.indexerService.lockIndexerQueue(this.luceneConnection);
    }

    protected void flushAndUnlockIndexerQueue(@NotNull IndexerContext indexerContext) {
        this.indexerService.flushAndUnlockIndexerQueue(indexerContext);
    }

    protected class UpdateApproximateIndexingTimePerResultCallback
    implements FutureCallback<Long> {
        final AtomicInteger tasksToProcess;
        final AtomicLong totalExecutionTime;
        final int indexedEntityCount;

        public UpdateApproximateIndexingTimePerResultCallback(int tasksToProcess, int indexedEntityCount) {
            this.tasksToProcess = new AtomicInteger(tasksToProcess);
            this.totalExecutionTime = new AtomicLong();
            this.indexedEntityCount = indexedEntityCount;
        }

        public void onSuccess(Long result) {
            this.totalExecutionTime.addAndGet(result);
            if (this.tasksToProcess.decrementAndGet() == 0) {
                AbstractIndexer.this.updateApproximateIndexingTimePerResult(this.totalExecutionTime.get(), this.indexedEntityCount);
            }
        }

        public void onFailure(Throwable t) {
            if (this.tasksToProcess.decrementAndGet() == 0) {
                AbstractIndexer.this.updateApproximateIndexingTimePerResult(this.totalExecutionTime.get(), this.indexedEntityCount);
            }
        }
    }

    protected class FlushAndUnlockIndexerQueueCallback
    implements FutureCallback<Long> {
        private final AtomicInteger tasksToProcess;
        private final IndexerContext indexerContext;

        public FlushAndUnlockIndexerQueueCallback(int tasksToProcess, IndexerContext indexerContext) {
            this.tasksToProcess = new AtomicInteger(tasksToProcess);
            this.indexerContext = indexerContext;
        }

        public void onSuccess(Long result) {
            if (this.tasksToProcess.decrementAndGet() == 0) {
                AbstractIndexer.this.flushAndUnlockIndexerQueue(this.indexerContext);
            }
        }

        public void onFailure(Throwable t) {
            if (this.tasksToProcess.decrementAndGet() == 0) {
                AbstractIndexer.this.flushAndUnlockIndexerQueue(this.indexerContext);
            }
            log.warn((Object)"Unexpected error while indexing. Your index might be incomplete", t);
        }
    }

    protected abstract class IndexAllCallable
    implements Callable<Long> {
        protected final IndexerContext indexerContext;

        protected IndexAllCallable(IndexerContext indexerContext) {
            this.indexerContext = indexerContext;
        }

        public abstract void run();

        @Override
        public Long call() throws Exception {
            Stopwatch stopWatch = Stopwatch.createStarted();
            this.run();
            return stopWatch.elapsed(TimeUnit.MILLISECONDS);
        }
    }
}

