/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestQuarantineHelper {
    private static final String QUARANTINE_TEST_KEY = "bamboo.system.getTestsToPass";
    private static final String TEST_CASE_SEPARATOR = "xXSePXxxXSePXx";
    private static final String TEST_CASE_INNER_SEPARATOR = "xXSePXx";

    private static String toDisplayString(TestCase testCase) {
        return TestQuarantineHelper.testToString(testCase.getName(), testCase.getTestClass().getName());
    }

    private static String toDisplayString(TestResults testResults) {
        return TestQuarantineHelper.testToString(testResults.getActualMethodName(), testResults.getClassName());
    }

    private TestQuarantineHelper() {
    }

    public static void put(ImmutableMap.Builder<String, String> customBuildDataBuilder, List<TestCase> quarantinedTests) {
        String quarantinedTestsString = quarantinedTests.stream().map(TestQuarantineHelper::toDisplayString).collect(Collectors.joining(TEST_CASE_SEPARATOR));
        customBuildDataBuilder.put((Object)QUARANTINE_TEST_KEY, (Object)quarantinedTestsString);
    }

    public static void remove(Map<String, ?> customBuildData) {
        customBuildData.remove(QUARANTINE_TEST_KEY);
    }

    @NotNull
    public static Set<String> getQuarantinedTests(Map<String, String> map) {
        String unparsedQuarantineData = TestQuarantineHelper.getUnparsedQuarantineData(map);
        if (unparsedQuarantineData == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet(TestQuarantineHelper.getUnparsedQuarantinedTests(unparsedQuarantineData));
    }

    public static boolean containsAll(Set<String> quarantinedTests, Collection<TestResults> failedTests) {
        Set failedTestsAsString = failedTests.stream().map(TestQuarantineHelper::toDisplayString).collect(Collectors.toSet());
        return quarantinedTests.containsAll(failedTestsAsString);
    }

    public static boolean contains(Set<String> quarantinedTests, TestCase testCase) {
        return quarantinedTests.contains(TestQuarantineHelper.toDisplayString(testCase));
    }

    @Nullable
    private static String getUnparsedQuarantineData(Map<String, String> map) {
        return map.get(QUARANTINE_TEST_KEY);
    }

    private static Iterable<String> getUnparsedQuarantinedTests(String unparsedQuarantineData) {
        return Splitter.on((String)TEST_CASE_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)unparsedQuarantineData);
    }

    static String testToString(String testName, String testClassName) {
        return testName.trim() + TEST_CASE_INNER_SEPARATOR + testClassName.trim();
    }
}

