/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.pipeline.concurrent;

import com.atlassian.bamboo.security.ImpersonationHelper;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger log = Logger.getLogger(NamedThreadFactory.class);
    private static final AtomicInteger THREAD_FACTORY_ID = new AtomicInteger();
    private final String threadName;
    private final ThreadFactory threadFactory;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public NamedThreadFactory(String threadName) {
        this(threadName, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error((Object)("Uncaught exception in thread " + t.getName()), e);
            }
        });
    }

    public NamedThreadFactory(String threadName, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.threadName = THREAD_FACTORY_ID.getAndIncrement() + "-" + threadName;
        this.threadFactory = Executors.defaultThreadFactory();
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Thread thread = this.threadFactory.newThread(ImpersonationHelper.makeRunnableWithSystemAuthority(r));
        thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        if (this.threadName != null) {
            thread.setName(this.threadName + ":" + thread.getName());
        }
        thread.setPriority(1);
        return thread;
    }
}

