/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public interface ExecutableAgentsHelper {
    public boolean planHasExecutableAgents(@NotNull PlanKey var1, boolean var2);

    public boolean planHasExecutableAgents(@NotNull PlanResultKey var1);

    public Collection<ElasticImageConfiguration> getExecutableImages(@NotNull ExecutorQuery var1);

    public Collection<BuildAgent> getExecutableAgents(@NotNull ExecutorQuery var1);

    public ExecutableAgentsMatrix getExecutableAgentsMatrix(@NotNull ExecutorQuery var1);

    public Collection<ImmutableBuildable> getExecutableBuildables(ExecutableQuery var1);

    public boolean isAgentEligibleForReceivingJobs(long var1);

    public static class ExecutableQuery {
        private final ReadOnlyCapabilitySet capabilitySet;
        private final Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors;

        public ExecutableQuery(@NotNull ReadOnlyCapabilitySet capabilitySet, @NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
            this.capabilitySet = capabilitySet;
            this.executors = executors;
        }

        public static ExecutableQuery newQuery(@NotNull ReadOnlyCapabilitySet capabilitySet, @NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
            return new ExecutableQuery(capabilitySet, executors);
        }

        public ReadOnlyCapabilitySet getCapabilities() {
            return this.capabilitySet;
        }

        public Iterable<AgentAssignmentService.AgentAssignmentExecutor> getExecutors() {
            return this.executors;
        }
    }

    public static class ExecutorQuery {
        private boolean disabledIncluded = false;
        private boolean offlineIncluded = false;
        private final MinimalRequirementSet requirements;
        private Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables;
        private CommonContext context;

        private ExecutorQuery(MinimalRequirementSet requirements) {
            this.requirements = requirements;
        }

        public ExecutorQuery withDisabledIncluded() {
            this.disabledIncluded = true;
            return this;
        }

        public ExecutorQuery withDisabledExcluded() {
            this.disabledIncluded = false;
            return this;
        }

        public ExecutorQuery withOfflineIncluded() {
            this.offlineIncluded = true;
            return this;
        }

        public ExecutorQuery withOfflineExcluded() {
            this.offlineIncluded = false;
            return this;
        }

        public static ExecutorQuery newQuery(@NotNull MinimalRequirementSet requirements) {
            return new ExecutorQuery(requirements);
        }

        public MinimalRequirementSet getRequirements() {
            return this.requirements;
        }

        public ExecutorQuery withAssignmentsFor(Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables) {
            this.executables = executables;
            return this;
        }

        public ExecutorQuery withContext(CommonContext context) {
            this.context = context;
            return this;
        }

        public boolean areDisabledIncluded() {
            return this.disabledIncluded;
        }

        public boolean areOfflineIncluded() {
            return this.offlineIncluded;
        }

        @Nullable
        public Iterable<AgentAssignmentService.AgentAssignmentExecutable> getAssignedExecutables() {
            return this.executables;
        }

        @Nullable
        public CommonContext getContext() {
            return this.context;
        }
    }
}

