/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.agent.capability;

import com.atlassian.bamboo.utils.Which;
import com.google.common.base.Predicate;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutablePathUtils {
    private static final Logger log = Logger.getLogger(ExecutablePathUtils.class);
    private static final String DOT_BAT = ".bat";
    private static final String BIN = "bin";

    private ExecutablePathUtils() {
    }

    public static boolean existsInHomeBinExePattern(@Nullable String homePath, @NotNull String executableName) {
        return ExecutablePathUtils.getExistingExecutable(homePath, executableName) != null;
    }

    public static Optional<File> getExistingExecutable(@Nullable String basePath, @NotNull String executableName) {
        if (basePath == null) {
            return Optional.empty();
        }
        File executable = ExecutablePathUtils.getExecutable(basePath, executableName);
        return executable.exists() ? Optional.of(executable) : Optional.empty();
    }

    @NotNull
    private static File getExecutable(@NotNull String homePath, @NotNull String executableName) {
        StringBuilder builder = new StringBuilder(homePath).append(File.separator).append(BIN).append(File.separator).append(executableName);
        return new File(builder.toString());
    }

    @NotNull
    public static String makeBatchIfOnWindows(String builder) {
        return SystemUtils.IS_OS_WINDOWS ? builder + DOT_BAT : builder;
    }

    @Nullable
    public static File detectExecutableOnPath(@NotNull String executableName) {
        File file;
        String executablePath = Which.execute(executableName);
        if (StringUtils.isNotEmpty((CharSequence)executablePath) && (file = new File(executablePath)).canExecute()) {
            try {
                return file.getCanonicalFile();
            }
            catch (IOException e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static File getHomeFromExecutableInHomeBin(@NotNull File executable) {
        File parent = executable.getParentFile();
        if (parent.isDirectory() && parent.getName().equals(BIN)) {
            return parent.getParentFile();
        }
        return null;
    }

    @Nullable
    public static File findExecutable(@NotNull String executableName, @Nullable Predicate<File> validityPredicate, @Nullable String envHomeDir, @Nullable String fhsHome) {
        Optional<File> optCandidate;
        if (validityPredicate == null) {
            validityPredicate = Objects::nonNull;
        }
        if ((optCandidate = ExecutablePathUtils.getExistingExecutable(envHomeDir, executableName).filter(arg_0 -> ((Predicate)validityPredicate).apply(arg_0))).isPresent()) {
            return optCandidate.get();
        }
        File executablePathCandidate = ExecutablePathUtils.detectExecutableOnPath(executableName);
        if (executablePathCandidate != null && validityPredicate.apply((Object)executablePathCandidate)) {
            return executablePathCandidate;
        }
        return ExecutablePathUtils.getExistingExecutable(fhsHome, executableName).filter(arg_0 -> ((Predicate)validityPredicate).apply(arg_0)).orElse(null);
    }

    @Nullable
    public static String findExecutablePath(@NotNull String executableName) {
        File file = ExecutablePathUtils.detectExecutableOnPath(executableName);
        return file != null ? file.getAbsolutePath() : null;
    }
}

