/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.util.UrlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Collection;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.taskdefs.Execute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemProperty {
    private static Logger log = Logger.getLogger(SystemProperty.class);
    private String myPropertyValue;
    private String myPropertyKey;
    public static final String BAMBOO_HOME_PROPERTY_NAME = "bamboo.home";
    public static final String BAMBOO_AGENT_BROKER_URL_PROPERTY_NAME = "bamboo.agent.brokerUrl";
    public static final SystemProperty BAMBOO_HOME_FROM_ENV = new SystemProperty(false, "bamboo.home", "BAMBOO_HOME");
    public static final SystemProperty MAVEN_HOME = new SystemProperty(false, "MAVEN_HOME");
    public static final SystemProperty MAVEN2_HOME = new SystemProperty(false, "M2_HOME", "MAVEN2_HOME");
    public static final SystemProperty ANT_HOME = new SystemProperty(false, "ANT_HOME");
    public static final SystemProperty DEFAULT_CVS_ROOT = new SystemProperty(false, "CVSROOT");
    public static final SystemProperty DEFAULT_PERFORCE_PORT = new SystemProperty(false, "P4PORT");
    public static final SystemProperty DEFAULT_PERFORCE_CLIENT = new SystemProperty(false, "P4CLIENT");
    public static final SystemProperty DEFAULT_PERFORCE_USER = new SystemProperty(false, "P4USER");
    public static final SystemProperty DEFAULT_P4_EXE = new SystemProperty(false, "P4EXE");
    public static final SystemProperty FIND_SUCCESS_MESSAGE_IN_LAST = new SystemProperty(false, "SUCCESS_MESSAGE_LINES");
    public static final SystemProperty BUILD_SUCCESSFUL_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.successMarker");
    public static final SystemProperty BUILD_FAILED_MARKER = new SystemProperty(false, "atlassian.bamboo.builder.failedMarker");
    public static final SystemProperty SEARCH_BUILD_SUCCESS_FAIL_MESSAGE_EVERYWHERE = new SystemProperty(false, "bamboo.build.searchSuccessFailMessageEverywhere");
    public static final BooleanSystemProperty DISABLE_AGENT_AUTO_CAPABILITY_DETECTION = new BooleanSystemProperty(false, false, "DISABLE_AGENT_AUTO_CAPABILITY_DETECTION");
    public static final SystemProperty SVN_SPOOL_TO_FILE = new SystemProperty(false, "SVN_SPOOL_TO_FILE");
    public static final SystemProperty BUILDING_DISABLED = new SystemProperty(false, "atlassian.bamboo.build.disable");
    public static final SystemProperty PATH = new SystemProperty(false, "PATH", "Path", "path");
    public static final SystemProperty CVS_TIME_DIFF = new SystemProperty(false, "atlassian.bamboo.cvsTimeDiff");
    public static final SystemProperty CVS_CHECKOUT_FORMAT = new SystemProperty(false, "CVS_CHECKOUT_FORMAT");
    public static final SystemProperty CVS_FORCE_CHECKOUT_TO_LATEST = new SystemProperty(false, "CVS_FORCE_CHECKOUT_TO_LATEST");
    public static final int CVS_SOCKET_TIMEOUT_MS = new SystemProperty(false, "CVS_SOCKET_TIMEOUT_MS").getValue((int)Duration.ofMinutes(1L).toMillis());
    public static final SystemProperty BUILD_RESULTS_CACHE_SIZE = new SystemProperty(false, "BUILD_RESULTS_CACHE_SIZE");
    public static final SystemProperty FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS = new SystemProperty(false, "FILTER_MAVEN_LOG_FOR_DOWNLOAD_STATUS");
    @Deprecated
    public static final SystemProperty SVN_WC_FORMAT = new SystemProperty(false, "bamboo.svn.wc.format");
    public static final SystemProperty SVN_CACHE_CREDENTIALS = new SystemProperty(false, "bamboo.svn.cache.credentials");
    public static final IntegerSystemProperty LOG_LINES_FOR_NOTIFICATIONS = new IntegerSystemProperty(false, 100L, "bamboo.notifications.logLinesToInclude");
    public static final IntegerSystemProperty FS_TIMESTAMP_RESOLUTION_MS = new IntegerSystemProperty(false, 100L, "bamboo.fs.timestamp.precision");
    public static final SystemProperty SEND_FILE_NAMES_TO_AGENT = new SystemProperty(false, "bamboo.send.file.names.to.agent");
    public static final SystemProperty ELASTIC_IMAGE_AMI_ID = new SystemProperty(false, "bamboo.aws.amiId");
    public static final BooleanSystemProperty EC2_HTTP_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.enabled");
    @Deprecated
    public static final SystemProperty EC2_TUNNEL_ENABLED = EC2_HTTP_TUNNEL_ENABLED;
    public static final BooleanSystemProperty EC2_JMS_TUNNEL_ENABLED = new BooleanSystemProperty(false, true, "bamboo.ec2.tunnel.jms.enabled");
    public static final SystemProperty EC2_IGNORE_CERT_CHECK = new SystemProperty(false, "bamboo.ec2.ignoreCertCheck");
    public static final SystemProperty FIRE_INITAL_BUILD_FOR_MANUAL_STRATEGY = new SystemProperty(false, "fire.initial.build.for.manual.strategy");
    public static final SystemProperty ALLOW_UNSUPPORTED_DB = new SystemProperty(false, "bamboo.enable.unsupported.db");
    public static final boolean PATH_SET_ALLOWED = new SystemProperty(false, "bamboo.paths.set.allowed").getValue(false);
    public static final SystemProperty BUILD_PARENT_JAVA_IO_TMPDIR = new SystemProperty(false, "bamboo.build.parent.java.io.tmpdir", "java.io.tmpdir");
    public static final SystemProperty EVENT_MANAGER_CORE_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.corePoolSize");
    public static final SystemProperty EVENT_MANAGER_MAXIMUM_POOL_SIZE = new SystemProperty(false, "bamboo.event.bambooEventManager.maximumPoolSize");
    public static final SystemProperty HG_COMMAND_FORCE_DEBUG = new SystemProperty(false, "bamboo.hg.debug");
    public static final SystemProperty DIRECTORY_SCANNING_PLUGIN_SCAN_DIR = new SystemProperty(false, "atlassian.bamboo.plugin.scan.directory");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_ID = new SystemProperty(false, "bamboo.ec2.agentLogAwsId");
    public static final SystemProperty ELASTIC_AGENT_LOG_AWS_SECRET = new SystemProperty(false, "bamboo.ec2.agentLogSecret");
    public static final SystemProperty BAMBOO_DELETION_ENABLED = new SystemProperty(false, "bamboo.deletion.enabled");
    public static final SystemProperty BAMBOO_RELOAD_AGENT_CLASSPATH = new SystemProperty(false, "bamboo.agent.reloadclasspath");
    public static final SystemProperty BAMBOO_MAX_AGENTS_LOADING = new SystemProperty(false, "bamboo.agent.max_loading");
    public static final SystemProperty BAMBOO_FREEMARKER_DEBUG = new SystemProperty(false, "bamboo.freemarker.debug");
    public static final SystemProperty MAX_VCS_OPERATION_RETRIES = new SystemProperty(false, "bamboo.vcs.retries");
    public static final SystemProperty PLAN_EXECUTION_DETECTION_THREADS = new SystemProperty(false, "bamboo.plan.exe.threads");
    public static final SystemProperty ARTIFACT_HANDLER_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.artifacthandlers");
    public static final SystemProperty ARTIFACT_COMPRESSION_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.artifactcompression");
    public static final SystemProperty ROTP_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.rotp");
    public static final SystemProperty ROTP_PROJECT_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.project.shortcuts");
    public static final SystemProperty ROTP_ADMIN_SHORTCUTS_DARK_FEATURE = new SystemProperty(false, "atlassian.darkfeature.rotp.admin.shortcuts");
    public static final SystemProperty PDL_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.pdl");
    public static final SystemProperty TRIGGERS_ON_ENVIRONMENT_PAGES_DARK_FEATURE = new SystemProperty(false, "bamboo.darkfeature.triggers.on.environment.pages");
    public static final SystemProperty BAMBOO_HOSTED_MODE = new SystemProperty(false, "bamboo.hosted.mode");
    public static final SystemProperty PLAN_CONFIG_SIMPLIFIED = new SystemProperty(false, "bamboo.darkfeature.planconfigsimplified");
    public static final SystemProperty BAMBOO_HOSTED_TEST_MODE = new SystemProperty(false, "bamboo.hosted.test.mode");
    public static final SystemProperty HG_CHANGE_SET_LIMIT = new SystemProperty(false, "HG_CHANGE_SET_LIMIT");
    public static final SystemProperty ARTIFACT_SIZE_LIMIT_PER_BUILD = new SystemProperty(false, "bamboo.artifact.size.limit.per.build");
    public static final SystemProperty DISABLE_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.branch.detection.disable");
    public static final SystemProperty DISABLE_CLOSED_BRANCH_DETECTION = new SystemProperty(false, "atlassian.bamboo.closed.branch.detection.disable");
    public static final SystemProperty ATLASSIAN_DEV_MODE = new SystemProperty(false, "atlassian.dev.mode");
    public static final SystemProperty BAMBOO_REQUEST_PROFILING = new SystemProperty(false, "bamboo.request.profiling");
    public static final BooleanSystemProperty ALLOW_MUTATIVE_GET_IN_STRICT_XSRF_MODE = new BooleanSystemProperty(false, false, "bamboo.allowMutativeGetInStrictXsrfMode");
    public static final BooleanSystemProperty BAMBOO_MANAGED_JMS_SSL = new BooleanSystemProperty(false, false, "bamboo.manage.jms.ssl");
    public static final SystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_SLEEP = new SystemProperty(false, "bamboo.export.wait.for.server.pause.sleep");
    public static final SystemProperty EXPORT_WAIT_FOR_SERVER_PAUSE_TIMEOUT = new SystemProperty(false, "bamboo.export.wait.for.server.pause.timeout");
    public static final SystemProperty EC2_AGENT_ENDPOINT = new SystemProperty(false, "bamboo.ec2.agent.endpoint");
    public static final SystemProperty FILE_UPLOAD_MAXIMUM_SIZE = new SystemProperty(false, "bamboo.file.upload.max.size");
    public static final BooleanSystemProperty BAMBOO_IGNORE_SERVER_STATE_ON_RESTART = new BooleanSystemProperty(false, true, "bamboo.ignore.server.state.on.restart");
    public static final BooleanSystemProperty ENABLE_JMS_OVER_HTTP = new BooleanSystemProperty(false, false, "bamboo.enable.jms.over.http");
    public static BooleanSystemProperty FUSION_DEPLOYMENTS_SUPPORT_DISABLED = new BooleanSystemProperty(false, false, "bamboo.fusion.deployments.support.disabled");
    public static final IntegerSystemProperty STASH_SSH_PORT_NUMBER = new IntegerSystemProperty(false, 7999L, "bamboo.stash.port.number");
    public static BooleanSystemProperty REMOVE_LABELS_AND_PLANS_FOR_NON_PLAN_ADMIN = new BooleanSystemProperty(false, false, "bamboo.remove.labels.by.non.plan.admin");
    public static BooleanSystemProperty DISABLE_STASH_BUILD_STATUS_UPDATES = new BooleanSystemProperty(false, false, "bamboo.stash.disable.build.status.updates");
    public static BooleanSystemProperty ENFORCE_POLLING_BRANCH_DETECTION_EVEN_WHEN_REPO_CAN_PUSH_IT = new BooleanSystemProperty(false, false, "bamboo.stash.enforce.polling.branches");
    public static BooleanSystemProperty CREATE_BRANCHES_FOR_PULL_REQUESTS_ENABLED = new BooleanSystemProperty(false, false, "bamboo.create.branches.for.pull.requests.enabled");
    public static IntegerSystemProperty STASH_REPOSITORY_TRIGGER_POLLING_INTERVAL = new IntegerSystemProperty(false, 0L, "bamboo.stash.repository.trigger.polling.interval");
    public static final BooleanSystemProperty AGENT_QUEUE_OFFLOADING_ENABLED = new BooleanSystemProperty(false, false, "bamboo.agent.queue.offloading.enabled");
    public static BooleanSystemProperty ENABLE_REMOTE_AGENTS_SHELL = new BooleanSystemProperty(false, false, "bamboo.enable.remote.agent.shell");
    public static final BooleanSystemProperty LIMITED_TIME_QUARANTINE_ENABLED = new BooleanSystemProperty(false, false, "bamboo.darkfeature.limited.time.quarantine");
    public static BooleanSystemProperty SKIP_BOOT_DELEGATION_OVERRIDES = new BooleanSystemProperty(false, false, "bamboo.skip.boot.delegation.override");
    public static BooleanSystemProperty ENABLE_XML_FACTORY_OVERRIDE = new BooleanSystemProperty(false, false, "bamboo.enable.xml.factory.override");
    public static final IntegerSystemProperty MAX_CONCURRENT_EXPENSIVE_MESSAGES = new IntegerSystemProperty(false, 1L, "bamboo.max.concurrent.expensive.messages");
    public static final BooleanSystemProperty PERSIST_RUNTIME_STATE = new BooleanSystemProperty(false, false, "bamboo.darkfeature.persist.runtime.state");
    public static final BooleanSystemProperty GLOBAL_REPOSITORY_DASHBOARD = new BooleanSystemProperty(false, false, "bamboo.darkfeature.repository.dashboard");
    public static final IntegerSystemProperty MAIL_QUEUE_SIZE = new IntegerSystemProperty(false, 1000L, "bamboo.mail.queue.size");
    public static final SystemProperty GRAVATAR_BASE_URL = new SystemProperty(false, "aid.avatar.url");
    public static final SystemProperty PLAN_DIRECTORY_INFO_REST = new SystemProperty(false, "bamboo.plan.directory.info.rest");
    public static final SystemProperty BAMBOO_INSTANCE_SPECIFIC_DATA_LOCATIONS = new SystemProperty(false, "bamboo.instance.specific.data.locations");
    public static final SystemProperty ELASTIC_AGENT_INSTANCE_NAME = new SystemProperty(false, "elastic.agent.instance.name");
    public static final BooleanSystemProperty CRYPTO_TRUST_JGIT_ALL = new BooleanSystemProperty(false, true, "bamboo.crypto.trust.jgit.all");
    public static final BooleanSystemProperty CRYPTO_TRUST_HG_SSH_ALL = new BooleanSystemProperty(false, false, "bamboo.crypto.trust.hg.ssh.all");
    public static final BooleanSystemProperty CRYPTO_TRUST_SVN_SSH_ALL = new BooleanSystemProperty(false, false, "bamboo.crypto.trust.svn.ssh.all");
    public static final BooleanSystemProperty DISABLE_SERIALIZATION_SECURITY = new BooleanSystemProperty(false, false, "bamboo.security.serialization.disable");
    public static final BooleanSystemProperty LEGACY_CLOUD_LICENSE_HANDLING = new BooleanSystemProperty(false, false, "bamboo.legacy.cloud.license.handling");

    public SystemProperty(boolean mandatory, String ... properties) {
        for (String property : properties) {
            this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
            if (this.myPropertyValue == null) continue;
            this.myPropertyKey = property;
            break;
        }
        if (this.myPropertyKey == null && properties.length == 1) {
            this.myPropertyKey = properties[0];
        }
    }

    @VisibleForTesting
    protected SystemProperty(String property, boolean mandatory, Logger log) {
        SystemProperty.log = log;
        this.myPropertyValue = SystemProperty.getEnvironmentVariable(property, mandatory);
    }

    @Nullable
    public String getValue() {
        return this.myPropertyValue;
    }

    public String getKey() {
        return this.myPropertyKey;
    }

    @NotNull
    public String getValue(@NotNull String defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue;
    }

    public boolean getValue(boolean defaultValue) {
        if (this.myPropertyValue == null) {
            return defaultValue;
        }
        return this.myPropertyValue.equals("true");
    }

    @Nullable
    protected static String getEnvironmentVariable(@NotNull String variable, boolean mandatory) {
        String value = System.getProperty(variable);
        if (value == null) {
            try {
                value = SystemProperty.obtainVariableFromSystemEnvironment(variable);
            }
            catch (Throwable throwable) {
                log.error((Object)("Could not access the system environment variable:\"" + variable + "\""), throwable);
                return null;
            }
        }
        if (value == null && mandatory) {
            log.error((Object)("Cannot find the " + variable + " environment variable"));
        }
        return value;
    }

    @Nullable
    private static String obtainVariableFromSystemEnvironment(@NotNull String variable) {
        String envVar = SystemProperty.getEnvVariableCaseSensitive(variable);
        if (envVar != null) {
            return envVar;
        }
        return SystemProperty.getPropertyFromAntEnv(variable);
    }

    private static String getEnvVariableCaseSensitive(String variable) {
        return System.getenv().get(variable);
    }

    @Nullable
    static String getPropertyFromAntEnv(@NotNull String variable) {
        Collection env = (Collection)Execute.getProcEnvironment().clone();
        for (Object anEnv : env) {
            String var = (String)anEnv;
            String key = StringUtils.substringBefore((String)var, (String)"=");
            if (!variable.equals(key)) continue;
            return StringUtils.substringAfter((String)var, (String)"=");
        }
        return null;
    }

    public void setValue(String propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public boolean exists() {
        return StringUtils.isNotEmpty((CharSequence)this.getValue());
    }

    public int getValue(int defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getValue(long defaultValue) {
        String stringValue = this.getValue();
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Cannot parse " + stringValue));
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static class UrlSystemProperty
    extends SystemProperty {
        public UrlSystemProperty(boolean mandatory, String ... properties) {
            super(mandatory, properties);
        }

        @Override
        @NotNull
        public String getValue(@NotNull String defaultValue) {
            return UrlUtils.correctlyFormatUrl(super.getValue(defaultValue));
        }
    }

    public static class BooleanSystemProperty
    extends SystemProperty {
        private final boolean defaultValue;

        public BooleanSystemProperty(boolean mandatory, boolean defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public boolean getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return BooleanUtils.toBoolean((String)stringValue);
        }

        public void setTypedValue(boolean value) {
            this.setValue(Boolean.toString(value));
        }
    }

    public static class IntegerSystemProperty
    extends SystemProperty {
        private final long defaultValue;

        public IntegerSystemProperty(boolean mandatory, long defaultValue, String ... properties) {
            super(mandatory, properties);
            this.defaultValue = defaultValue;
        }

        public long getTypedValue() {
            String stringValue = this.getValue();
            if (stringValue == null) {
                return this.defaultValue;
            }
            return Integer.parseInt(stringValue);
        }
    }
}

