/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.NumberUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Either;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooFilenameUtils {
    private static final Logger log = Logger.getLogger(BambooFilenameUtils.class);

    private BambooFilenameUtils() {
    }

    public static boolean isPathAbsolute(String path) {
        return FilenameUtils.getPrefixLength((String)path) > 0;
    }

    public static boolean doesPathFollowToParentDirectory(String path) {
        return path != null && FilenameUtils.normalize((String)path) == null;
    }

    public static String getScriptSuffix() {
        return SystemUtils.IS_OS_WINDOWS ? ".bat" : ".sh";
    }

    public static Either<String, File> getShortWindowsPath(String path) {
        List list;
        File pathArg = new File(path);
        Preconditions.checkArgument((boolean)pathArg.exists(), (Object)(path + " does not exist"));
        if (!SystemUtils.IS_OS_WINDOWS) {
            return Either.right((Object)pathArg);
        }
        String cmd = "cmd /c for %I in (\"" + path + "\") do @echo %~sI";
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)ImmutableList.copyOf((Iterable)Splitter.on((char)' ').split((CharSequence)cmd)));
        try {
            Process start = processBuilder.start();
            list = IOUtils.readLines((InputStream)start.getInputStream());
        }
        catch (IOException e) {
            return Either.left((Object)e.getMessage());
        }
        if (list.size() != 1) {
            return Either.left((Object)("Don't know how to parse: " + Iterables.toString((Iterable)list)));
        }
        String shortPath = (String)Iterables.getOnlyElement((Iterable)list);
        File shortPathFile = new File(shortPath);
        if (!shortPathFile.exists()) {
            return Either.left((Object)("short path for " + path + " does not exist"));
        }
        return Either.right((Object)shortPathFile);
    }

    @NotNull
    public static File shortenNameIfPossible(@NotNull File file) {
        Either<String, File> shortWindowsPath = BambooFilenameUtils.getShortWindowsPath(file.getAbsolutePath());
        if (shortWindowsPath.isLeft()) {
            log.warn((Object)("Unable to shorten: " + (String)shortWindowsPath.left().get()));
            return file;
        }
        return (File)shortWindowsPath.right().get();
    }

    @NotNull
    public static String makeTempFileName(@NotNull String prefix, @Nullable String suffix) {
        return prefix + NumberUtils.randomNonNegativeLong() + (String)StringUtils.defaultIfBlank((CharSequence)suffix, (CharSequence)".tmp");
    }

    @Nullable
    public static String stripTrailingSlashes(@Nullable String path) {
        if (path != null && (path.endsWith("/") || path.endsWith("\\"))) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean containsDirectoryTraversalString(@Nullable String name) {
        if (name == null) {
            return false;
        }
        if (StringUtils.indexOfAny((CharSequence)name, (CharSequence[])new CharSequence[]{"/..", "../", "\\..", "..\\"}) >= 0) {
            return true;
        }
        return name.startsWith("..") || name.endsWith("..");
    }
}

