/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary.tests;

import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.persistence3.BambooObjectDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestCase;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResult;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultStatisticsProvider;
import com.atlassian.bamboo.resultsummary.tests.TestDeltaState;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.Pair;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TestCaseResultDao
extends BambooObjectDao<TestCaseResult> {
    public TestCaseResult findById(long var1);

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByState(ResultsSummary var1, TestState var2);

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByState(ResultsSummary var1, TestState var2, int var3, int var4);

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultByDeltaState(ResultsSummary var1, TestDeltaState var2, int var3, int var4);

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByDeltaStates(ChainResultsSummary var1, TestDeltaState[] var2, int var3, int var4);

    @NotNull
    public List<TestCaseResult> getTestsForChainResultByState(@NotNull ChainResultsSummary var1, @NotNull TestState var2, int var3, int var4);

    @NotNull
    public List<TestCaseResult> getQuarantinedTestCasesForChainResult(@NotNull ChainResultsSummary var1);

    @NotNull
    public List<TestCaseResult> getTestsForBuildResultSummary(BuildResultsSummary var1);

    @NotNull
    public List<TestCaseResult> getQuarantinedTestCasesForBuildResult(@NotNull BuildResultsSummary var1);

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatisticsForTestCase(@NotNull TestCase var1);

    @NotNull
    public List<TestCaseResultStatisticsProvider> getResultStatisticsForTestCaseAndBuilds(@NotNull TestCase var1, @NotNull List<BuildResultsSummary> var2);

    @NotNull
    public List<TestCaseResult> getTestCaseResultsForTestCase(@NotNull TestCase var1);

    @NotNull
    public List<TestCaseResult> getTestCaseResultsForTestCaseAndBuilds(@NotNull TestCase var1, @NotNull List<BuildResultsSummary> var2);

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResultsForTestCase(@NotNull TestCase var1, int var2);

    @NotNull
    public List<Pair<TestCaseResult, Integer>> getLastNFailingResultsForTestCaseAndBuildResults(@NotNull TestCase var1, @NotNull List<BuildResultsSummary> var2, int var3);

    @Deprecated
    @Nullable
    public TestCaseResult getTestCaseResult(TestCase var1, long var2);

    @NotNull
    public List<TestCaseResult> getTestCaseResults(TestCase var1, long var2);

    @Nullable
    public BuildResultsSummary getSucceedingSinceBuildResultSummary(TestCase var1);

    public long countTestCaseResults();

    public long countTestCaseResultErrors();

    public long scrollTestCaseResultsForExport(@NotNull Consumer<TestCaseResult> var1);

    public long scrollTestCaseResultErrorsForExport(@NotNull Consumer<TestCaseResultError> var1);
}

