/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results.tests;

import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.resultsummary.tests.TestCaseResultError;
import com.atlassian.bamboo.resultsummary.tests.TestState;
import com.atlassian.bamboo.utils.DurationUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class TestResults
implements Serializable,
Comparable<TestResults> {
    private static final double VERY_QUICK = 0.0;
    private String myName;
    private String myClassName;
    private String myDuration;
    private FinalArrayList<TestCaseResultError> myErrors = new FinalArrayList();
    private String cachedPrettyDuration;
    private String systemOut;
    private TestState state;
    private long testCaseId;

    public TestResults() {
    }

    public TestResults(String className, String methodName, String duration) {
        this.myClassName = className;
        this.myDuration = duration;
        this.myName = methodName;
    }

    public String getActualMethodName() {
        return this.myName;
    }

    public String getMethodName() {
        String TEST_PREFIX = "test";
        if (this.myName == null || this.myName.length() < 2) {
            return this.myName;
        }
        String lowerCase = this.myName.toLowerCase();
        if ("test".equals(lowerCase)) {
            return this.myName;
        }
        String prefixRemoved = StringUtils.removeStartIgnoreCase((String)this.myName, (String)"test");
        String wordsSeparated = prefixRemoved.replaceAll("[A-Z]", " $0").replace('_', ' ').replaceAll("\\s+", " ").toLowerCase().trim();
        if (StringUtils.isBlank((CharSequence)wordsSeparated)) {
            return this.myName.trim();
        }
        return Character.toUpperCase(wordsSeparated.charAt(0)) + wordsSeparated.substring(1);
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getShortClassName() {
        if (StringUtils.contains((CharSequence)this.myClassName, (CharSequence)".")) {
            return StringUtils.substringAfterLast((String)this.myClassName, (String)".");
        }
        return this.myClassName;
    }

    public String getDuration() {
        return this.myDuration;
    }

    public void addError(TestCaseResultError error) {
        this.myErrors.add(error);
    }

    public List<TestCaseResultError> getErrors() {
        return this.myErrors;
    }

    public void setSystemOut(String systemOut) {
        this.systemOut = systemOut;
    }

    public String getSystemOut() {
        return this.systemOut;
    }

    public boolean hasErrors() {
        return !this.myErrors.isEmpty();
    }

    public double getDurationInSeconds() {
        String duration = this.getDuration();
        if (StringUtils.isNotEmpty((CharSequence)duration)) {
            try {
                return Double.parseDouble(duration);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public String getPrettyDuration() {
        if (this.cachedPrettyDuration == null) {
            this.cachedPrettyDuration = DurationUtils.getPrettyPrint((long)(this.getDurationInSeconds() * 1000.0), false);
        }
        return this.cachedPrettyDuration;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("classname", (Object)this.getClassName()).add("methodname", (Object)this.getActualMethodName()).add("duration", (Object)this.getDuration()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TestResults)) {
            return false;
        }
        TestResults rhs = (TestResults)o;
        return new EqualsBuilder().append((Object)this.getClassName(), (Object)rhs.getClassName()).append((Object)this.getActualMethodName(), (Object)rhs.getActualMethodName()).isEquals();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClassName(), this.getActualMethodName()});
    }

    @Override
    public int compareTo(TestResults o) {
        return new CompareToBuilder().append((Object)this.getClassName(), (Object)o.getClassName()).append((Object)this.getActualMethodName(), (Object)o.getActualMethodName()).toComparison();
    }

    public TestState getState() {
        return this.state;
    }

    public void setState(TestState state) {
        this.state = state;
    }

    public long getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(long testCaseId) {
        this.testCaseId = testCaseId;
    }
}

