/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.bamboo.repository.Repository;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class CacheId {
    private final Repository repository;
    private String context;
    private final String[] ids;

    public CacheId(Repository repository, String ... ids) {
        this.repository = repository;
        this.ids = ids;
        this.context = null;
    }

    private CacheId(CacheId cacheId, String context) {
        this.repository = cacheId.repository;
        this.ids = cacheId.ids;
        this.context = context;
    }

    public static CacheId forContext(CacheId cacheId, @Nullable String context) {
        return context == null ? cacheId : new CacheId(cacheId, context);
    }

    @Nullable
    public String getContext() {
        return this.context;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheId cacheId = (CacheId)o;
        if (this.context != null ? !this.context.equals(cacheId.context) : cacheId.context != null) {
            return false;
        }
        return Arrays.equals(this.ids, cacheId.ids);
    }

    public int hashCode() {
        int result = this.context != null ? this.context.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.ids);
        return result;
    }
}

