/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.progressbar;

import com.atlassian.bamboo.plan.ExecutionStatus;
import com.atlassian.bamboo.progressbar.ProgressBar;
import com.atlassian.bamboo.utils.DurationUtils;

public class ProgressBarImpl
implements ProgressBar {
    private static final double ONE_HUNDRED_PERCENT = 1.0;
    private static final double WIDTH = 100.0;
    private final ExecutionStatus executionStatus;

    public ProgressBarImpl(ExecutionStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public boolean isValid() {
        return this.getEstimatedDuration() > 0L;
    }

    @Override
    public boolean isUnderAverageTime() {
        return this.getPercentageCompleted() < 1.0;
    }

    @Override
    public double getPercentageCompleted() {
        long duration = this.getEstimatedDuration();
        double elapsed = this.getBuildTime();
        return duration == 0L ? 1.0 : elapsed / (double)duration;
    }

    @Override
    public String getPrettyTimeRemaining(boolean isLong) {
        if (this.isUnderAverageTime()) {
            if (isLong) {
                return "Approximately " + DurationUtils.getPrettyPrint(this.getEstimatedDuration() - this.getBuildTime()) + " remaining";
            }
            return DurationUtils.getPrettyPrint(this.getEstimatedDuration() - this.getBuildTime(), false) + " remaining";
        }
        return DurationUtils.getPrettyPrint(this.getBuildTime() - this.getEstimatedDuration(), isLong) + " slower than usual";
    }

    @Override
    public String getPrettyTimeRemaining() {
        return this.getPrettyTimeRemaining(true);
    }

    @Override
    public String getPercentageCompletedAsString() {
        return (int)(this.getPercentageCompleted() * 100.0) + "%";
    }

    @Override
    public int getTotalTimeWidth() {
        if (this.isUnderAverageTime()) {
            return 100;
        }
        return (int)(1.0 / this.getPercentageCompleted() * 100.0);
    }

    @Override
    public int getTimeElapsedWidth() {
        if (!this.isUnderAverageTime()) {
            return 100;
        }
        return (int)(this.getPercentageCompleted() * 100.0);
    }

    @Override
    public long getEstimatedDuration() {
        return this.executionStatus.getAverageDuration();
    }

    private long getBuildTime() {
        return this.executionStatus.getElapsedTime();
    }
}

