/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.test;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.results.tests.TestResults;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

@PublicApi
public final class TestCollectionResultBuilder {
    private static final Logger log = Logger.getLogger(TestCollectionResultBuilder.class);
    private final List<TestResults> successfulTestResults = new ArrayList<TestResults>();
    private final List<TestResults> failedTestResults = new ArrayList<TestResults>();
    private final List<TestResults> skippedTestResults = new ArrayList<TestResults>();

    public TestCollectionResultBuilder addSuccessfulTestResults(Collection<TestResults> successfulTestResults) {
        this.successfulTestResults.addAll(successfulTestResults);
        return this;
    }

    public TestCollectionResultBuilder addFailedTestResults(Collection<TestResults> failedTestResults) {
        this.failedTestResults.addAll(failedTestResults);
        return this;
    }

    public TestCollectionResultBuilder addSkippedTestResults(Collection<TestResults> skippedTestResults) {
        this.skippedTestResults.addAll(skippedTestResults);
        return this;
    }

    public TestCollectionResult build() {
        return new TestCollectionResultImpl(this.successfulTestResults, this.failedTestResults, this.skippedTestResults);
    }

    private static final class TestCollectionResultImpl
    implements TestCollectionResult {
        private final List<TestResults> successfulTestResults;
        private final List<TestResults> failedTestResults;
        private final List<TestResults> skippedTestResults;

        private TestCollectionResultImpl(List<TestResults> successfulTestResults, List<TestResults> failedTestResults, List<TestResults> skippedTestResults) {
            this.successfulTestResults = successfulTestResults;
            this.failedTestResults = failedTestResults;
            this.skippedTestResults = skippedTestResults;
        }

        @Override
        public List<TestResults> getSuccessfulTestResults() {
            return this.successfulTestResults;
        }

        @Override
        public List<TestResults> getFailedTestResults() {
            return this.failedTestResults;
        }

        @Override
        public List<TestResults> getSkippedTestResults() {
            return this.skippedTestResults;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("successfulTestResults", this.successfulTestResults.size()).add("failedTestResults", this.failedTestResults.size()).add("skippedTestResults", this.skippedTestResults.size()).toString();
        }
    }
}

