/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.v2.build.trigger.AbstractTriggerReason;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ManualBuildTriggerReason
extends AbstractTriggerReason {
    private static final Logger log = Logger.getLogger(ManualBuildTriggerReason.class);
    public static final String KEY = "com.atlassian.bamboo.plugin.system.triggerReason:ManualBuildTriggerReason";
    public static final String TRIGGER_MANUAL_USER = "ManualBuildTriggerReason.userName";
    public static final String TRIGGER_MANUAL_STAGE = "ManualBuildTriggerReason.stageName";
    private String userName;
    private String stageName;

    @Override
    public String getName() {
        return "Manual build";
    }

    @Override
    public String getNameForSentence() {
        return TextProviderUtils.getHtml(this.textProvider, "build.triggerreason.manualbuild", this.userName);
    }

    @Override
    public void init(String key, Map<String, String> fields) {
        this.init(key);
        this.userName = Narrow.to(fields.get(TRIGGER_MANUAL_USER), String.class);
        this.stageName = Narrow.to(fields.get(TRIGGER_MANUAL_STAGE), String.class);
    }

    @Override
    public void init(String key, @NotNull ResultsSummary resultsSummary) {
        this.init(key, resultsSummary.getCustomBuildData());
    }

    @Override
    public void updateBuildResultsSummary(ResultsSummary resultsSummary) {
        this.updateCustomData(resultsSummary);
    }

    @Override
    public void updateCustomData(@NotNull BambooCustomDataAware customDataAware) {
        if (this.userName != null) {
            customDataAware.updateCustomDataEntry(TRIGGER_MANUAL_USER, this.userName);
        }
        if (this.stageName != null) {
            customDataAware.updateCustomDataEntry(TRIGGER_MANUAL_STAGE, this.stageName);
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }
}

