/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.trigger;

import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomRevisionBuildTriggerReason
extends ManualBuildTriggerReason {
    private static final Logger log = Logger.getLogger(CustomRevisionBuildTriggerReason.class);
    public static final String KEY = "com.atlassian.bamboo.plugin.system.triggerReason:CustomRevisionBuildTriggerReason";
    public static final String TRIGGER_CUSTOM_REVISION = "ManualBuildTriggerReason.customRevision";
    private String revision;
    private String planResultKey;

    @Override
    public String getName() {
        return "Custom revision build";
    }

    @Override
    public String getNameForSentence() {
        return TextProviderUtils.getHtml(this.textProvider, "build.triggerreason.customRevisionBuild", this.getUserName(), this.revision);
    }

    @Override
    public void init(String key, Map<String, String> fields) {
        super.init(key, fields);
        this.revision = fields.get(TRIGGER_CUSTOM_REVISION);
        if (this.planResultKey == null) {
            this.planResultKey = fields.get("buildKey");
        }
    }

    @Override
    public void init(String key, @NotNull ResultsSummary resultsSummary) {
        this.init(key, resultsSummary.getCustomBuildData());
        this.planResultKey = resultsSummary.getPlanResultKey().toString();
    }

    @Override
    public void updateCustomData(@NotNull BambooCustomDataAware customDataAware) {
        super.updateCustomData(customDataAware);
        if (this.revision != null) {
            customDataAware.updateCustomDataEntry(TRIGGER_CUSTOM_REVISION, this.revision);
        }
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    @Nullable
    public String getPlanResultKey() {
        return this.planResultKey;
    }
}

