/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.bamboo.utils.NameProvider;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NameProviderFunctions {
    private NameProviderFunctions() {
    }

    public static Function<NameProvider, String> getName() {
        return GetName.INSTANCE;
    }

    public static Predicate<NameProvider> isNameEqual(@NotNull String name) {
        return new IsNameEqual(name);
    }

    public static Predicate<NameProvider> isNameIn(@NotNull Collection<String> names) {
        return Predicates.compose((Predicate)Predicates.in(names), NameProviderFunctions.getName());
    }

    private static class IsNameEqual
    implements Predicate<NameProvider> {
        private final String name;

        private IsNameEqual(@NotNull String name) {
            this.name = name;
        }

        public boolean apply(@Nullable NameProvider input) {
            return Objects.equal((Object)this.name, (Object)((NameProvider)Preconditions.checkNotNull((Object)input)).getName());
        }
    }

    private static enum GetName implements Function<NameProvider, String>
    {
        INSTANCE;


        @Nullable
        public String apply(@Nullable NameProvider input) {
            return ((NameProvider)Preconditions.checkNotNull((Object)input)).getName();
        }
    }
}

