/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;

public class BambooSpringUtils {
    private BambooSpringUtils() {
    }

    @NotNull
    public static TransactionTemplate readOnly(@NotNull TransactionTemplate transactionTemplate) {
        DefaultTransactionDefinition readOnlyTransactionDefition = new DefaultTransactionDefinition();
        readOnlyTransactionDefition.setIsolationLevel(transactionTemplate.getIsolationLevel());
        readOnlyTransactionDefition.setName(transactionTemplate.getName());
        readOnlyTransactionDefition.setPropagationBehavior(transactionTemplate.getPropagationBehavior());
        readOnlyTransactionDefition.setReadOnly(true);
        readOnlyTransactionDefition.setTimeout(transactionTemplate.getTimeout());
        return new TransactionTemplate(transactionTemplate.getTransactionManager(), (TransactionDefinition)readOnlyTransactionDefition);
    }

    @NotNull
    public static TransactionTemplate requiresNew(@NotNull TransactionTemplate transactionTemplate) {
        DefaultTransactionDefinition readOnlyTransactionDefition = new DefaultTransactionDefinition();
        readOnlyTransactionDefition.setIsolationLevel(transactionTemplate.getIsolationLevel());
        readOnlyTransactionDefition.setName(transactionTemplate.getName());
        readOnlyTransactionDefition.setPropagationBehavior(3);
        readOnlyTransactionDefition.setReadOnly(transactionTemplate.isReadOnly());
        readOnlyTransactionDefition.setTimeout(transactionTemplate.getTimeout());
        return new TransactionTemplate(transactionTemplate.getTransactionManager(), (TransactionDefinition)readOnlyTransactionDefition);
    }
}

