/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.results;

import com.atlassian.bamboo.ReasonForBuild;
import com.atlassian.bamboo.build.Artifact;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.progressbar.ProgressBar;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.trigger.DependencyTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.trigger.InitialBuildTriggerReason;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class BuildResultsImpl
implements BuildResults {
    private static final Logger log = Logger.getLogger(BuildResultsImpl.class);
    private volatile transient PlanManager planManager;
    private volatile transient ResultsSummaryManager resultsSummaryManager;
    private transient String buildKey;
    private transient StopWatch stopWatch;
    private transient File mySourceDirectory;
    private transient ProgressBar progressBar;
    private Map<String, String> customBuildInfo;
    private transient BuildChanges buildChanges;
    private transient int buildReturnCode;
    private transient Set<Commit> commits;
    private ReasonForBuild myReasonForBuild;
    private BuildState myBuildState;
    private List<String> myBuildErrors;
    private int myBuildNumber;
    private Date myBuildDate;
    private long myBuildDuration;
    private List<TestResults> mySuccessfulTestResults;
    private transient Map<Long, TestResults> successfulTestResultsMap;
    @Deprecated
    private List<TestResults> myFailedTestResults;
    @Deprecated
    private Map<String, Artifact> myArtifacts;
    private transient Collection myChangeList;
    private transient BuildResultsSummary buildResultsSummary;
    private transient String myBuildName;
    private transient String myProjectName;
    private transient List myBuildOutput;
    private transient List buildLog;

    public BuildResultsImpl() {
    }

    public BuildResultsImpl(String buildKey, BuildState state, List<String> buildErrors, Collection<Commit> commits, ReasonForBuild reasonForBuild) {
        this.buildKey = buildKey;
        this.myBuildState = state;
        this.myBuildErrors = buildErrors;
        if (commits != null) {
            this.commits = new LinkedHashSet<Commit>(commits);
        }
        this.myReasonForBuild = reasonForBuild;
    }

    public Buildable getBuildable() {
        if (this.getPlanManager() == null) {
            throw new IllegalStateException("getBuild called without the container being injected");
        }
        return this.getPlanManager().getPlanByKey(this.getBuildKey(), Buildable.class);
    }

    @Override
    public BuildChanges getBuildChanges() {
        return this.buildChanges;
    }

    @Override
    public void setBuildChanges(BuildChanges buildChanges) {
        this.buildChanges = buildChanges;
    }

    @Override
    public String getBuildKey() {
        return this.buildKey;
    }

    @Override
    public String getFullKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    @Override
    public BuildResultsSummary getBuildResultsSummary() {
        ResultsSummaryManager resultsSummaryManager = this.getResultsSummaryManager();
        return resultsSummaryManager.getResultsSummary(PlanKeys.getPlanResultKey(this.getBuildKey(), this.getBuildNumber()), BuildResultsSummary.class);
    }

    public ResultsSummaryManager getResultsSummaryManager() {
        if (this.resultsSummaryManager == null) {
            this.resultsSummaryManager = (ResultsSummaryManager)ContainerManager.getComponent((String)"resultsSummaryManager");
        }
        return this.resultsSummaryManager;
    }

    @Override
    public void setStartTime(Date date) {
        this.myBuildDate = date;
    }

    @Override
    public Date getStartTime() {
        if (this.myBuildDate == null) {
            this.myBuildDate = new Date();
        }
        return this.myBuildDate;
    }

    @Override
    public Date getBuildCompletedTimeStamp() {
        return new Date(this.getStartTime().getTime() + this.getBuildDurationInMilliseconds());
    }

    @Override
    public void setDurationInMilliseconds(long buildDuration) {
        this.myBuildDuration = buildDuration;
    }

    @Override
    public long getBuildDurationInMilliseconds() {
        return this.myBuildDuration;
    }

    @Override
    public BuildState getBuildState() {
        return this.myBuildState;
    }

    @Override
    public void setBuildState(@NotNull BuildState buildState) {
        this.myBuildState = buildState;
    }

    @Override
    public void addBuildErrors(List<String> errorMessages) {
        if (errorMessages != null) {
            this.getBuildErrors().addAll(errorMessages);
        }
    }

    @Override
    @NotNull
    public List<String> getBuildErrors() {
        if (this.myBuildErrors == null) {
            this.myBuildErrors = Lists.newArrayList();
        }
        return this.myBuildErrors;
    }

    @Deprecated
    public void setBuildErrors(List<String> buildErrors) {
        this.myBuildErrors = buildErrors;
    }

    @Override
    public BuildResults cloneAsBuildResults(BuildContext buildContext, ReasonForBuild reasonForBuild) {
        BuildResultsImpl buildResults = new BuildResultsImpl(buildContext.getPlanKey(), this.getBuildState(), this.getBuildErrors(), null, reasonForBuild);
        buildResults.setBuildNumber(buildContext.getBuildNumber());
        buildResults.setPlanManager(this.getPlanManager());
        buildResults.setBuildChanges(buildContext.getBuildChanges());
        buildResults.setDurationInMilliseconds(this.getBuildDurationInMilliseconds());
        buildResults.setStartTime(this.getStartTime());
        Map<String, String> clonedCustomData = buildResults.getCustomBuildData();
        Map<String, String> customData = this.getCustomBuildData();
        if (customData != null) {
            for (Map.Entry<String, String> customDataEntry : customData.entrySet()) {
                clonedCustomData.put(customDataEntry.getKey(), customDataEntry.getValue());
            }
        }
        return buildResults;
    }

    @Override
    public void setBuildNumber(int buildNumber) {
        this.myBuildNumber = buildNumber;
        this.getCustomBuildData().put("buildNumber", Integer.toString(buildNumber));
    }

    @Override
    public int getBuildNumber() {
        return this.myBuildNumber;
    }

    @Override
    public ReasonForBuild getReasonForBuild() {
        return this.myReasonForBuild;
    }

    @Override
    public void setReasonForBuild(ReasonForBuild reasonForBuild) {
        this.myReasonForBuild = reasonForBuild;
    }

    @Override
    @NotNull
    public Map<String, String> getCustomBuildData() {
        if (this.customBuildInfo == null) {
            this.customBuildInfo = Maps.newHashMap();
            this.customBuildInfo.put("buildNumber", Integer.toString(this.getBuildNumber()));
            this.customBuildInfo.put("buildKey", this.buildKey);
        }
        return this.customBuildInfo;
    }

    @Override
    public void setCustomBuildData(Map<String, String> customBuildData) {
        this.customBuildInfo = customBuildData;
    }

    @Override
    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    @Override
    public int getBuildReturnCode() {
        return this.buildReturnCode;
    }

    @Override
    public void setBuildReturnCode(int buildReturnCode) {
        this.buildReturnCode = buildReturnCode;
    }

    @Override
    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    @Override
    @Deprecated
    public TestResultsSummary getTestResults() {
        return this.getBuildResultsSummary().getTestResultsSummary();
    }

    @Override
    public void setSuccessfulTestResults(List<TestResults> mySuccessfulTestResults) {
        this.mySuccessfulTestResults = mySuccessfulTestResults;
        this.successfulTestResultsMap = null;
    }

    @Override
    public List<TestResults> getSuccessfulTestResults() {
        return this.mySuccessfulTestResults;
    }

    @Override
    public Map<Long, TestResults> getSuccessfulTestResultsMap() {
        if (this.successfulTestResultsMap != null) {
            return this.successfulTestResultsMap;
        }
        if (this.mySuccessfulTestResults != null) {
            this.successfulTestResultsMap = new HashMap<Long, TestResults>();
            for (TestResults tr : this.mySuccessfulTestResults) {
                this.successfulTestResultsMap.put(tr.getTestCaseId(), tr);
            }
            return this.successfulTestResultsMap;
        }
        return null;
    }

    @Override
    @Deprecated
    public void setFailedTestResults(List<TestResults> myFailedTestResults) {
        this.myFailedTestResults = myFailedTestResults;
    }

    @Override
    public List<TestResults> getFailedTestResults() {
        return this.myFailedTestResults;
    }

    @Override
    @Deprecated
    public void setMyArtifacts(Map<String, Artifact> myArtifacts) {
        this.myArtifacts = myArtifacts;
    }

    @Deprecated
    public Map<String, Artifact> getMyArtifacts() {
        return this.myArtifacts;
    }

    @Override
    public boolean isCurrentlyQueuedOnly() {
        return this.getBuildNumber() == 0;
    }

    @Override
    public StopWatch getStopWatch() {
        if (this.stopWatch == null) {
            this.stopWatch = new StopWatch();
        }
        return this.stopWatch;
    }

    public void startTimer() {
        this.getStopWatch().start();
    }

    public void stopTimer() {
        StopWatch stopWatch = this.getStopWatch();
        stopWatch.stop();
        this.setDurationInMilliseconds(stopWatch.getTime());
    }

    @Override
    public void clearBuildErrors() {
        this.getBuildErrors().clear();
    }

    @Override
    public long getBuildTime() {
        return this.getStopWatch().getTime();
    }

    @Override
    public String getPrettyBuildTime() {
        return DurationUtils.getPrettyPrint(this.getBuildTime());
    }

    @Override
    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    @Override
    public String getBuildResultsKey() {
        return this.getBuildKey() + "-" + this.getBuildNumber();
    }

    public String toString() {
        return "BuildResults: " + this.getBuildResultsKey();
    }

    public PlanManager getPlanManager() {
        if (this.planManager == null) {
            this.planManager = (PlanManager)ContainerManager.getComponent((String)"planManager");
        }
        return this.planManager;
    }

    public static ReasonForBuild getReasonForBuild(BuildContext buildContext) {
        TriggerReason reason = buildContext.getTriggerReason();
        if (reason instanceof ManualBuildTriggerReason) {
            return ReasonForBuild.MANUAL_BUILD;
        }
        if (reason instanceof DependencyTriggerReason) {
            return ReasonForBuild.DEPENDENCY_BUILD;
        }
        if (reason instanceof InitialBuildTriggerReason) {
            return ReasonForBuild.INITIAL_CLEAN_BUILD;
        }
        return ReasonForBuild.CODE_HAS_CHANGED;
    }
}

