/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.cache;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.BambooCacheStats;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
@Internal
public interface ImmutablePlanCacheService {
    @Nullable
    public ImmutableChain getImmutablePlanByKey(@NotNull PlanKey var1);

    @NotNull
    public List<ImmutableChainBranch> getBranchesForChain(@NotNull PlanKey var1);

    @Nullable
    public ImmutableJob getMasterOfJob(@NotNull PlanKey var1, @NotNull PlanKey var2);

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> var1);

    @NotNull
    public <T extends ImmutablePlan> List<T> getPlans(Class<T> var1, @NotNull Predicate<? super T> var2);

    @Nullable
    public PlanIdentifier getPlanIdentifierForPermissionCheckingByKey(@NotNull PlanKey var1);

    public ReentrantReadWriteLock getLock(@NotNull PlanKey var1);

    public void invalidate(@NotNull PlanKey var1);

    public void cascadeInvalidate(@NotNull PlanKey var1);

    public void cascadeInvalidate(long var1);

    public void reset(@NotNull PlanKey var1);

    public void resetAll();

    public void initialiseCache();

    public void disableCache();

    public void enableCache();

    public BambooCacheStats getCacheStats();

    @Deprecated
    @Internal
    public void setBuildNumberOverrides(PlanKey var1, int var2, int var3, int var4);

    @Deprecated
    @Internal
    @Nullable
    public int[] getBuildNumberOverrides(PlanKey var1);

    @Internal
    @NotNull
    public Iterable<PlanKey> getChainsToInvalidate(@NotNull CacheInvalidator var1);

    @Internal
    public static interface CacheInvalidator {
        public String getDescription();

        @NotNull
        public Iterable<PlanKey> getChainsToInvalidate(ImmutablePlanCacheService var1, Cache<PlanKey, ImmutableChain> var2);
    }
}

