/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractErrorUpdateHandler
implements ErrorUpdateHandler {
    private AgentContext agentContext;

    @Override
    @Deprecated
    public void recordError(String buildKey, String context) {
        this.createError(buildKey, null, this.getCurrentAgentId(), context, null);
    }

    @Override
    public void recordError(@NotNull Key planKey, @Nullable String context) {
        this.createError(planKey.getKey(), null, this.getCurrentAgentId(), context, null);
    }

    @Override
    @Deprecated
    public void recordError(String buildKey, String context, Throwable throwable) {
        this.createError(buildKey, null, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    public void recordError(@NotNull Key planKey, @Nullable String context, @NotNull Throwable throwable) {
        this.createError(planKey.getKey(), null, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    @Deprecated
    public void recordError(String buildKey, int buildNumber, String context, Throwable throwable) {
        this.createError(buildKey, buildNumber, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    public void recordError(@NotNull ResultKey planResultKey, String context, @Nullable Throwable throwable) {
        this.createError(planResultKey.getEntityKey().getKey(), planResultKey.getResultNumber(), this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
    }

    @Override
    @Deprecated
    public void recordError(@Nullable BuildContext buildContext, @NotNull String context, @Nullable Throwable throwable) {
        if (buildContext != null) {
            this.createError(buildContext.getPlanKey(), buildContext.getBuildNumber(), this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
        } else {
            this.createError(null, -1, this.getCurrentAgentId(), context, ThrowableDetails.fromThrowable(throwable));
        }
    }

    @Override
    public void recordError(String errorMessage) {
        this.createError(null, -1, this.getCurrentAgentId(), errorMessage, null);
    }

    @Override
    public void recordElasticError(String context, @Nullable Long agentId, @Nullable Throwable throwable, @Nullable String instanceId) {
        this.createElasticError(context, agentId, ThrowableDetails.fromThrowable(throwable), instanceId);
    }

    @Override
    @Deprecated
    public void addErrorCollection(String buildKey, ErrorCollection errors) {
        for (String errorMessage : errors.getErrorMessages()) {
            this.recordError(buildKey, errorMessage);
        }
    }

    @Override
    public void addErrorCollection(ResultKey buildKey, ErrorCollection errors) {
        for (String errorMessage : errors.getErrorMessages()) {
            this.recordError(buildKey, errorMessage, null);
        }
    }

    @Nullable
    protected Long getCurrentAgentId() {
        ExecutableBuildAgent buildAgent = this.agentContext != null ? this.agentContext.getBuildAgent() : null;
        return buildAgent != null ? Long.valueOf(buildAgent.getId()) : null;
    }

    public void setAgentContext(AgentContext agentContext) {
        this.agentContext = agentContext;
    }
}

