/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jira.rest;

import com.atlassian.bamboo.jira.rest.Errors;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JiraRestResponse {
    private static final Logger log = Logger.getLogger(JiraRestResponse.class);
    @NotNull
    public final int statusCode;
    @Nullable
    public final String statusMessage;
    @Nullable
    public final Errors errors;
    @Nullable
    public final String body;
    @Nullable
    public final JSONObject entity;

    public JiraRestResponse(String errorMessage) {
        this.errors = new Errors();
        this.errors.addError(errorMessage);
        this.statusCode = Integer.MAX_VALUE;
        this.statusMessage = null;
        this.body = null;
        this.entity = null;
    }

    public JiraRestResponse(int statusCode, String statusMessage, Errors errors, String body, JSONObject entity) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.errors = errors;
        this.body = body;
        this.entity = entity;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean hasErrors() {
        return this.errors != null && (!this.errors.errorMessages.isEmpty() || !this.errors.errors.isEmpty());
    }

    public static class JiraRestResponseBuilder {
        private int statusCode;
        private String statusMessage;
        private Errors errors;
        private String body;
        private JSONObject entity;

        public JiraRestResponseBuilder(int statusCode, String statusMessage) {
            this.statusCode = statusCode;
            this.statusMessage = statusMessage;
        }

        public JiraRestResponseBuilder errors(Errors errors) {
            this.errors = errors;
            return this;
        }

        public JiraRestResponseBuilder body(String body) {
            this.body = body;
            return this;
        }

        public JiraRestResponseBuilder entity(JSONObject entity) {
            this.entity = entity;
            return this;
        }

        public JiraRestResponseBuilder addError(String s) {
            if (this.errors == null) {
                this.errors = new Errors();
            }
            this.errors.addError(s);
            return this;
        }

        public JiraRestResponse build() {
            return new JiraRestResponse(this.statusCode, this.statusMessage, this.errors, this.body, this.entity);
        }
    }
}

