/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.collect.Sets;
import java.util.HashSet;

public class AgentAssignmentServiceHelper {
    private AgentAssignmentServiceHelper() {
    }

    public static AgentAssignmentService.AgentAssignmentExecutor asExecutor(AgentAssignment.ExecutorType executorType, long executorId) {
        return new AgentAssignmentService.AgentAssignmentExecutor(executorType, executorId);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(BuildAgent agent, boolean directAssignmentsOnly) {
        return AgentAssignmentServiceHelper.asExecutors(agent.getDefinition(), directAssignmentsOnly);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(BuildAgent agent) {
        return AgentAssignmentServiceHelper.asExecutors(agent.getDefinition());
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(ElasticImageConfiguration elasticImageConfiguration) {
        return Sets.newHashSet((Object[])new AgentAssignmentService.AgentAssignmentExecutor[]{new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.IMAGE, elasticImageConfiguration.getId())});
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(PipelineDefinition pipelineDefinition) {
        return AgentAssignmentServiceHelper.asExecutors(pipelineDefinition, false);
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutor> asExecutors(PipelineDefinition pipelineDefinition, final boolean directAssignmentsOnly) {
        final HashSet executors = Sets.newHashSet();
        pipelineDefinition.accept(new PipelineDefinitionVisitor(){

            @Override
            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
                if (!directAssignmentsOnly) {
                    executors.add(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.IMAGE, pipelineDefinition.getElasticImageConfigurationId()));
                }
            }

            @Override
            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
            }

            @Override
            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                this.visitAgent(pipelineDefinition);
            }

            private void visitAgent(PipelineDefinition pipelineDefinition) {
                executors.add(new AgentAssignmentService.AgentAssignmentExecutor(AgentAssignment.ExecutorType.AGENT, pipelineDefinition.getId()));
            }
        });
        return executors;
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> asExecutables(ImmutableBuildable buildable) {
        return Sets.newHashSet((Object[])new AgentAssignmentService.AgentAssignmentExecutable[]{new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.JOB, buildable.getId())});
    }

    public static Iterable<AgentAssignmentService.AgentAssignmentExecutable> environmentToExecutables(long environmentId) {
        return Sets.newHashSet((Object[])new AgentAssignmentService.AgentAssignmentExecutable[]{new AgentAssignmentService.AgentAssignmentExecutable(AgentAssignment.ExecutableType.ENVIRONMENT, environmentId)});
    }
}

