/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.buildqueue.manager;

import com.atlassian.bamboo.buildqueue.AgentAssignment;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentAssignmentMap {
    final Cache<AgentAssignmentService.AgentAssignmentExecutor, Set<AgentAssignmentService.AgentAssignmentExecutable>> executorToExecutable = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<AgentAssignmentService.AgentAssignmentExecutor, Set<AgentAssignmentService.AgentAssignmentExecutable>>(){

        public Set<AgentAssignmentService.AgentAssignmentExecutable> load(AgentAssignmentService.AgentAssignmentExecutor key) throws Exception {
            return Sets.newHashSet();
        }
    });
    final Cache<AgentAssignmentService.AgentAssignmentExecutable, Set<AgentAssignmentService.AgentAssignmentExecutor>> executableToExecutor = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<AgentAssignmentService.AgentAssignmentExecutable, Set<AgentAssignmentService.AgentAssignmentExecutor>>(){

        public Set<AgentAssignmentService.AgentAssignmentExecutor> load(AgentAssignmentService.AgentAssignmentExecutable key) throws Exception {
            return Sets.newHashSet();
        }
    });

    public AgentAssignmentMap(Iterable<AgentAssignment> agentAssignments) {
        AgentAssignmentService.AgentAssignmentExecutor executor;
        for (AgentAssignment agentAssignment : agentAssignments) {
            executor = new AgentAssignmentService.AgentAssignmentExecutor(agentAssignment.getId(), agentAssignment.getExecutorType(), agentAssignment.getExecutorId());
            AgentAssignmentService.AgentAssignmentExecutable executable = new AgentAssignmentService.AgentAssignmentExecutable(agentAssignment.getId(), agentAssignment.getExecutableType(), agentAssignment.getExecutableId());
            ((Set)this.executorToExecutable.getUnchecked((Object)executor)).add(executable);
        }
        for (Map.Entry entry : this.executorToExecutable.asMap().entrySet()) {
            executor = (AgentAssignmentService.AgentAssignmentExecutor)entry.getKey();
            Set executables = (Set)entry.getValue();
            for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
                ((Set)this.executableToExecutor.getUnchecked((Object)executable)).add(executor);
            }
        }
    }

    public Set<AgentAssignmentService.AgentAssignmentExecutable> forExecutors(Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
        HashSet executables = Sets.newHashSet();
        for (AgentAssignmentService.AgentAssignmentExecutor executor : executors) {
            executables.addAll((Collection)this.executorToExecutable.getUnchecked((Object)executor));
        }
        return executables;
    }

    public Set<AgentAssignmentService.AgentAssignmentExecutor> forExecutables(@NotNull Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables) {
        HashSet executors = Sets.newHashSet();
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            executors.addAll((Collection)this.executableToExecutor.getUnchecked((Object)executable));
        }
        return executors;
    }

    public AgentAssignmentCheckResult checkAssignmentRequirements(@Nullable Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables, Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
        if (executables == null) {
            return AgentAssignmentCheckResult.NO_AGENT_ASSIGNMENTS;
        }
        HashSet executorsForExecutable = Sets.newHashSet();
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            executorsForExecutable.addAll((Collection)this.executableToExecutor.getUnchecked((Object)executable));
        }
        HashSet executablesForExecutors = Sets.newHashSet();
        for (AgentAssignmentService.AgentAssignmentExecutor executor : executors) {
            executablesForExecutors.addAll((Collection)this.executorToExecutable.getUnchecked((Object)executor));
        }
        if (executorsForExecutable.isEmpty() && executablesForExecutors.isEmpty()) {
            return AgentAssignmentCheckResult.NO_AGENT_ASSIGNMENTS;
        }
        for (AgentAssignmentService.AgentAssignmentExecutable executable : executables) {
            if (!executablesForExecutors.contains(executable)) continue;
            return AgentAssignmentCheckResult.AGENT_MEETS_ASSIGNMENT_REQUIREMENTS;
        }
        if (executorsForExecutable.isEmpty()) {
            return AgentAssignmentCheckResult.AGENT_EXCLUSIVELY_ASSIGNED_ELSEWHERE;
        }
        return AgentAssignmentCheckResult.AGENT_DOES_NOT_MEET_ASSIGNMENT_REQUIREMENTS;
    }

    public static enum AgentAssignmentCheckResult {
        AGENT_DOES_NOT_MEET_ASSIGNMENT_REQUIREMENTS(false),
        AGENT_MEETS_ASSIGNMENT_REQUIREMENTS(true),
        AGENT_EXCLUSIVELY_ASSIGNED_ELSEWHERE(false),
        NO_AGENT_ASSIGNMENTS(true);

        private boolean canExecute;

        private AgentAssignmentCheckResult(boolean canExecute) {
            this.canExecute = canExecute;
        }

        public boolean isCanExecute() {
            return this.canExecute;
        }
    }
}

