/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger.interceptors;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.collection.FIFOBoundedList;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ErrorMemorisingInterceptor
implements LogInterceptor {
    private static final Logger log = Logger.getLogger(ErrorMemorisingInterceptor.class);
    private final List<LogEntry> errorEntries;

    @Deprecated
    public ErrorMemorisingInterceptor() {
        this.errorEntries = Lists.newArrayList();
    }

    public ErrorMemorisingInterceptor(int limit) {
        this.errorEntries = new FIFOBoundedList<LogEntry>(limit);
    }

    public static ErrorMemorisingInterceptor newInterceptor() {
        return new ErrorMemorisingInterceptor((int)SystemProperty.LOG_LINES_FOR_NOTIFICATIONS.getTypedValue());
    }

    @Override
    public void intercept(@NotNull LogEntry logEntry) {
    }

    @Override
    public void interceptError(@NotNull LogEntry logEntry) {
        this.errorEntries.add(logEntry);
    }

    public List<String> getErrorStringList() {
        return Lists.newArrayList((Iterable)Collections2.transform(this.errorEntries, (Function)new Function<LogEntry, String>(){

            public String apply(LogEntry input) {
                return input.getUnstyledLog();
            }
        }));
    }
}

